% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_homeless_population_by_year.R
\name{nyc_homeless_population_by_year}
\alias{nyc_homeless_population_by_year}
\title{NYC Homeless Population By Year}
\source{
NYC Open Data: <https://data.cityofnewyork.us/Social-Services/Directory-Of-Homeless-Population-By-Year/5t4n-d72c/about_data>
}
\usage{
nyc_homeless_population_by_year(limit = 10000, filters = list())
}
\arguments{
\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{filters}{Optional list of field-value pairs to filter results.}
}
\value{
A tibble containing Directory Of Homeless Population By Year data.
}
\description{
Directory Of Homeless Population By Year
}
\details{
Table of homeless population by Year (for years 2009 through 2012)
}
\examples{
# Quick example (fetch 10 rows)
small_sample <- nyc_homeless_population_by_year(limit = 10)
head(small_sample)

\donttest{
nyc_homeless_population_by_year(limit = 5000)
nyc_homeless_population_by_year(filters = list(area = "Subways"))
}
}
