% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weights_and_seats.R
\name{weight_polls}
\alias{weight_polls}
\title{Weight polls}
\usage{
weight_polls(polldates, n = rep(1, length(polldates)), method = c("pundit",
  "curia"), refdate = Sys.Date(), electiondate = as.Date("2017-09-23"))
}
\arguments{
\item{polldates}{a vector of dates of polls.}

\item{n}{a vector of sample sizes of polls.}

\item{method}{which weighting method to use; either that used in 2017 by Curia or Pundit 
(two New Zealand poll aggregators).}

\item{refdate}{date against which to compare polling dates (both methods give more weight
to more recent polls).}

\item{electiondate}{date of the next election (the Curia weighting method gives more weight
to polls close to the election).}
}
\value{
a vector of weights, adding up to one, for use in calculating a weighted average of 
opinion polls
}
\description{
Create a vector of weights to use in calculating a weighted average
}
\details{
This function is experimental and so far it has not been possible to match published 
results.  Use with caution.

This function is to facilitate reproduction of existing poll aggregation methods.

Both methods provide weights proportional to the sample sizes.

The Pundit Poll of Polls states its method is an adaptation of that used by 
fivethirtyeight.  It gives polls a half life of 30 days, so a poll that is 
120 days old gets 0.125 the weight of one conducted today.

The Curia method gives weight of 1 to all polls that are seven or less days old;
0 to polls older than 38 days; and a linear interpolation for inbetween.  Note that
this method gives zero weight to many older surveys that would get a weight in the 
pundit method.

Caution - as at March 2017, this function had failed to exactly replicate results on the 
webpages of Curia and Pundit.
}
\examples{
polldates <- tail(unique(polls$MidDate), 20)
weight_polls(polldates, method = "curia", refdate = as.Date("2017-09-22"))
weight_polls(polldates, method = "pundit", refdate = as.Date("2017-09-22"))
}
\references{
\url{http://www.curia.co.nz/methodology/}
\url{http://www.pundit.co.nz/content/poll-of-polls}
}
