% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{.checkdatastr2}
\alias{.checkdatastr2}
\title{Check data structure}
\usage{
.checkdatastr2(dat, xf, yf, verbose = FALSE)
}
\arguments{
\item{dat}{A dataframe containing occurrence data for checking.}

\item{xf}{character. Name of the field where the x coordinate is stored (typically longitude). Default is x.field}

\item{yf}{character. Name of the field where the y coordinate is stored (typically latitude). Default is y.field}

\item{verbose}{logical. Print messages? Defaults to FALSE}
}
\value{
Original dataframe, dat.  Used primarily to generate warning messages.
}
\description{
Verify that all main data fields are correctly structured
}
\details{
Inspired by \link[biogeo]{checkdatastr} but modified (hence number 2 after the function original name)
}
\seealso{
Other checks: 
\code{\link{.addmainfields2}()},
\code{\link{.check.geospatial.data}()},
\code{\link{.checkfields}()},
\code{\link{.status.tracker.and.escaping}()}
}
\author{
Mark Robertson and Vernon Visser (original function), Josep M Serra Diaz (modifs)
}
\concept{checks}
