% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alphaHulls.R
\name{getPointsOutAlphaHull}
\alias{getPointsOutAlphaHull}
\title{Generate Spatial object from Alpha Hull object}
\usage{
getPointsOutAlphaHull(
  x,
  alpha = 2,
  coordHeaders = c("Longitude", "Latitude"),
  proj = "+proj=longlat +datum=WGS84",
  verbose = FALSE,
  alphaCap = 20
)
}
\arguments{
\item{x}{dataframe of coordinates in decimal degrees, with a minimum of 3
rows.}

\item{alpha}{the starting value for alpha.}

\item{coordHeaders}{the column names for the longitude and latitude
columns, respectively.  If x has two columns, these are assumed to be
longitude and latitude, and \code{coordHeaders} is ignored.}

\item{proj}{the projection information for x. The default is currently the
only supported option.}

\item{verbose}{logical. print messages? Default to FALSE}

\item{alphaCap}{Max alpha value before function aborts and returns a
minimum convex hull.}
}
\value{
a list with 2 elements: \item{hull}{ a SpatialPolygons object }
\item{alpha}{ the alpha value that was found to satisfy the criteria.  If a
convex hull was returned, this will list MCH.  }
}
\description{
Generate polygon based on alpha hulls at a given alpha parmater
}
\details{
Based on rangeBuilder::getDynamicRange without cropping to sea and without increments
\code{alpha = initialAlpha}, and will then increase \code{alpha} by
\code{alphaIncrement} until both the \code{fraction} and \code{partCount}
conditions are met.

If the conditions cannot be satisfied, then a minimum convex hull is
returned.

If \code{clipToCoast} is set to "terrestrial" or "aquatic", the resulting
polygon is clipped to the coastline, using the dataset
provided with this package.
}
\seealso{
Alpha hulls are created with \code{\link{ahull}}.
}
\author{
Pascal Title (original version), Josep M Serra-Diaz (modifs)
}
\keyword{internal}
