% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Table.R
\name{odbc-tables}
\alias{odbc-tables}
\alias{dbWriteTable,OdbcConnection,character,data.frame-method}
\alias{dbWriteTable,OdbcConnection,Id,data.frame-method}
\alias{dbWriteTable,OdbcConnection,SQL,data.frame-method}
\alias{dbAppendTable,OdbcConnection-method}
\alias{sqlData,OdbcConnection-method}
\alias{sqlCreateTable,OdbcConnection-method}
\title{Convenience functions for reading/writing DBMS tables}
\usage{
\S4method{dbWriteTable}{OdbcConnection,character,data.frame}(
  conn,
  name,
  value,
  overwrite = FALSE,
  append = FALSE,
  temporary = FALSE,
  row.names = NA,
  field.types = NULL,
  batch_rows = getOption("odbc.batch_rows", NA),
  ...
)

\S4method{dbWriteTable}{OdbcConnection,Id,data.frame}(
  conn,
  name,
  value,
  overwrite = FALSE,
  append = FALSE,
  temporary = FALSE,
  row.names = NA,
  field.types = NULL,
  batch_rows = getOption("odbc.batch_rows", NA),
  ...
)

\S4method{dbWriteTable}{OdbcConnection,SQL,data.frame}(
  conn,
  name,
  value,
  overwrite = FALSE,
  append = FALSE,
  temporary = FALSE,
  row.names = NA,
  field.types = NULL,
  batch_rows = getOption("odbc.batch_rows", NA),
  ...
)

\S4method{dbAppendTable}{OdbcConnection}(conn, name, value, ..., row.names = NULL)

\S4method{sqlData}{OdbcConnection}(con, value, row.names = NA, ...)

\S4method{sqlCreateTable}{OdbcConnection}(
  con,
  table,
  fields,
  row.names = NA,
  temporary = FALSE,
  ...,
  field.types = NULL
)
}
\arguments{
\item{conn}{a \code{\linkS4class{OdbcConnection}} object, produced by
\code{\link[DBI:dbConnect]{DBI::dbConnect()}}}

\item{name}{a character string specifying a table name. Names will be
automatically quoted so you can use any sequence of characters, not
just any valid bare table name.}

\item{value}{A data.frame to write to the database.}

\item{overwrite}{Allow overwriting the destination table. Cannot be
\code{TRUE} if \code{append} is also \code{TRUE}.}

\item{append}{Allow appending to the destination table. Cannot be
\code{TRUE} if \code{overwrite} is also \code{TRUE}.}

\item{temporary}{If \code{TRUE}, will generate a temporary table statement.}

\item{row.names}{Either \code{TRUE}, \code{FALSE}, \code{NA} or a string.

If \code{TRUE}, always translate row names to a column called "row_names".
If \code{FALSE}, never translate row names. If \code{NA}, translate
rownames only if they're a character vector.

A string is equivalent to \code{TRUE}, but allows you to override the
default name.

For backward compatibility, \code{NULL} is equivalent to \code{FALSE}.}

\item{field.types}{Additional field types used to override derived types.}

\item{batch_rows}{The number of rows to retrieve. Defaults to \code{NA}, which is set dynamically to the size of the input. Depending on
the database, driver, dataset and free memory setting this to a lower value may improve
performance.}

\item{...}{Other arguments used by individual methods.}

\item{con}{A database connection.}

\item{table}{The table name, passed on to \code{\link[DBI:dbQuoteIdentifier]{dbQuoteIdentifier()}}. Options are:
\itemize{
\item a character string with the unquoted DBMS table name,
e.g. \code{"table_name"},
\item a call to \code{\link[DBI:Id]{Id()}} with components to the fully qualified table name,
e.g. \code{Id(schema = "my_schema", table = "table_name")}
\item a call to \code{\link[DBI:SQL]{SQL()}} with the quoted and fully qualified table name
given verbatim, e.g. \code{SQL('"my_schema"."table_name"')}
}}

\item{fields}{Either a character vector or a data frame.

A named character vector: Names are column names, values are types.
Names are escaped with \code{\link[DBI:dbQuoteIdentifier]{dbQuoteIdentifier()}}.
Field types are unescaped.

A data frame: field types are generated using
\code{\link[DBI:dbDataType]{dbDataType()}}.}
}
\description{
Convenience functions for reading/writing DBMS tables
}
\examples{
\dontrun{
library(DBI)
con <- dbConnect(odbc::odbc())
dbListTables(con)
dbWriteTable(con, "mtcars", mtcars, temporary = TRUE)
dbReadTable(con, "mtcars")

dbListTables(con)
dbExistsTable(con, "mtcars")

# A zero row data frame just creates a table definition.
dbWriteTable(con, "mtcars2", mtcars[0, ], temporary = TRUE)
dbReadTable(con, "mtcars2")

dbDisconnect(con)
}
}
