% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Connection.R, R/db.R
\name{odbcConnectionTables}
\alias{odbcConnectionTables}
\alias{odbcConnectionTables,OdbcConnection,Id-method}
\alias{odbcConnectionTables,OdbcConnection,character-method}
\alias{odbcConnectionTables,OdbcConnection,ANY-method}
\alias{odbcConnectionTables,OdbcConnection,SQL-method}
\alias{odbcConnectionTables,Oracle,character-method}
\title{odbcConnectionTables}
\usage{
odbcConnectionTables(conn, name, ...)

\S4method{odbcConnectionTables}{OdbcConnection,Id}(conn, name, table_type = NULL)

\S4method{odbcConnectionTables}{OdbcConnection,character}(
  conn,
  name,
  catalog_name = NULL,
  schema_name = NULL,
  table_type = NULL
)

\S4method{odbcConnectionTables}{OdbcConnection,ANY}(
  conn,
  name = NULL,
  catalog_name = NULL,
  schema_name = NULL,
  table_type = NULL
)

\S4method{odbcConnectionTables}{OdbcConnection,SQL}(conn, name, table_type = NULL)

\S4method{odbcConnectionTables}{Oracle,character}(
  conn,
  name,
  catalog_name = NULL,
  schema_name = NULL,
  table_type = NULL
)
}
\arguments{
\item{conn}{OdbcConnection}

\item{name}{table we wish to search for}

\item{...}{additional parameters to methods}

\item{table_type}{List tables of this type, for example 'VIEW'.
See odbcConnectionTableTypes for a listing of available table
types for your connection.}

\item{catalog_name}{character catalog where we wish to query for
available tables}

\item{schema_name}{character schema where we wish to query for
available tables.}
}
\value{
data.frame with columns
\itemize{
\item table_catalog
\item table_schema
\item table_name
\item table_remarks
}
}
\description{
This function returns a listing of tables accessible
to the connected user.
The expectation is that this is a relatively thin
wrapper around the ODBC \code{SQLTables} function call,
albeit returning a subset of the fields.
}
\details{
It is important to note that, similar to the ODBC/API
call, this method also accomodates pattern-value arguments
for the catalog, schema, and table name arguments.

If extending this method, be aware that \code{package:odbc}
internally uses this method to satisfy both
DBI::dbListTables and DBI::dbExistsTable methods.
( The former also advertises pattern value arguments )

Query, rather than use SQLTables ODBC API for performance reasons on Oracle.
Main functional difference between the implementation of SQLTables ( OEM driver )
and the query below is that the OEM implementation also looks through the synonyms.
Given the performance reports, we sacrifice the synonym look-through for
better execution time.
}
\seealso{
The ODBC documentation on \href{https://docs.microsoft.com/en-us/sql/odbc/reference/syntax/sqlcolumns-function}{SQLTables}
for further details.
}
