% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_haplotypes.R
\name{parents_haplotypes}
\alias{parents_haplotypes}
\title{Generates data.frame with parents estimated haplotypes}
\usage{
parents_haplotypes(
  ...,
  group_names = NULL,
  map.function = "kosambi",
  ref_alt_alleles = FALSE
)
}
\arguments{
\item{...}{objects of class sequence}

\item{group_names}{vector of characters defining the group names}

\item{map.function}{"kosambi" or "haldane" according to which was used to build the map}

\item{ref_alt_alleles}{TRUE to return parents haplotypes as reference and alternative ref_alt_alleles codification}
}
\value{
data.frame with group ID (group), marker number (mk.number) 
and names (mk.names), position in centimorgan (dist) and parents haplotypes 
(P1_1, P1_2, P2_1, P2_2)
}
\description{
Generates data.frame with parents estimated haplotypes
}
\examples{
\donttest{
data("onemap_example_out")
twopts <- rf_2pts(onemap_example_out)
lg1 <- make_seq(twopts, 1:5)
lg1.map <- map(lg1)
parents_haplotypes(lg1.map)
}
}
\author{
Getulio Caixeta Ferreira, \email{getulio.caifer@gmail.com}

Cristiane Taniguti, \email{chtaniguti@tamu.edu}
}
