% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.token.R
\name{opal.token_sql_create}
\alias{opal.token_sql_create}
\title{Create a personal access token for SQL usage}
\usage{
opal.token_sql_create(opal, name, projects = NULL)
}
\arguments{
\item{opal}{Opal object.}

\item{name}{Name of the token}

\item{projects}{Vector of project names, to which the token applies. Default is NULL (all projects).}
}
\value{
The token value.
}
\description{
Create a personal access token for SQL usage. Like for the other token functions, 
this operation requires the user to authenticate with username/password credentials.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
token <- opal.token_sql_create(o, 'sql-1')
opal.logout(o)
}
}
\seealso{
Other token functions: 
\code{\link{opal.token}()},
\code{\link{opal.token_datashield_create}()},
\code{\link{opal.token_delete}()},
\code{\link{opal.token_r_create}()},
\code{\link{opal.token_renew}()},
\code{\link{opal.tokens}()}
}
\concept{token functions}
