% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{non_parm}
\alias{non_parm}
\title{Non-parametric method}
\usage{
non_parm(Y, X, control = NULL, wgt = rep(1, length(Y)), lambda = 100,
  ...)
}
\arguments{
\item{Y}{outcome vector (must be numeric without NA's).}

\item{X}{numeric data frame or matrix of factors to be considered.}

\item{control}{numeric data frame or matrix of factors to control for. these are factors
that we can't consider while looking for the optimal intervention
(e.g. race).}

\item{wgt}{an optional vector of weights.}

\item{lambda}{the lagrange multiplier. also known as the shadow price of an
intervention.}

\item{...}{additional arguments.}
}
\value{
vector of weights under I = 1
}
\description{
Calculates weights under I = 1, using the non-parametric method
}
