################################################################################
# Tests for solve_reg_fm_prob, which wraps fmatch and provides some useful statistics
################################################################################

context("solve_reg_fm_prob")

### Commented out because matched.distances = TRUE not implemented yet.
### test_that("Matched Distances", {
###   d <- matrix(c(1,2,3,4), nrow = 2, dimnames = list(c(1,2), c(3,4)))
###   # these values were generated by debugging the fullmatch function on:
###   #   fullmatch(d)
###   # and then saving the call to solve_reg_fm_prob
###   max.cpt <- 2
###   min.cpt <- 0.5
###   tolerance <- 0.004
###   # omit.fraction is NULL
###
###   res <- solve_reg_fm_prob(rownames = rownames(d), colnames = colnames(d),
###                      distmat = d, max.cpt = max.cpt, min.cpt = min.cpt,
###                      tolerance = tolerance, omit.fraction = NULL)
###
###   # result from .fullmatch
###   # cells
###   # 1 2 3 4
###   # 1 2 1 2
###   #
###   # $err
###   # [1] -0.008
###   #
###   # $match.distance
###   # [1] 0
###
###   # if the pairs are 1-3, 2-4, the matched distances are c(1,4)
###
###   expect_equivalent(res$match.distance, c(1,4))
###
### })

test_that("nodes_shell_fmatch() helper",{
    expect_is(nodes_shell_fmatch(c(1,2), c(3,4)), "NodeInfo")
})

test_that("No Warnings", {
  d <- matrix(c(1,2,3,4), nrow = 2, dimnames = list(c(1,2), c(3,4)))
  d  <- new("DenseMatrix", d)
  # these values were generated by debugging the fullmatch function on:
  #   fullmatch(d)
  # and then saving the call to solve_reg_fm_prob
  max.cpt <- 2
  min.cpt <- 0.5
  tolerance <- 0.004
  # omit.fraction is NULL

  if (requireNamespace("rrelaxiv", quietly = TRUE)) {
    expect_silent(
    res <- solve_reg_fm_prob(node_info = nodes_shell_fmatch(rownames(d), colnames(d)),
                       distspec = d, max.cpt = max.cpt, min.cpt = min.cpt,
                       tolerance = tolerance, omit.fraction = NULL, solver = "RELAX-IV")
  )
    slvr <- "RELAX-IV"
  }
  expect_silent(
    res <- solve_reg_fm_prob(node_info = nodes_shell_fmatch(rownames(d), colnames(d)),
                       distspec = d, max.cpt = max.cpt, min.cpt = min.cpt,
                       tolerance = tolerance, omit.fraction = NULL, solver = "LEMON")
  )
})

test_that("NA for unmatched items", {
  d <- matrix(c(1,2, 3,4, Inf, Inf), nrow = 2, dimnames = list(c(1,2), c(3,4, "U")))
  d  <- new("DenseMatrix", d)
  max.cpt <- 3
  min.cpt <- 0.5
  tolerance <- 0.005

  if (requireNamespace("rrelaxiv", quietly = TRUE)) {
    slvr <- "RELAX-IV"
    res <- solve_reg_fm_prob(node_info = nodes_shell_fmatch(rownames(d), colnames(d)),
                     distspec = d, max.cpt = max.cpt, min.cpt = min.cpt,
                     tolerance = tolerance, omit.fraction = NULL, solver = "RELAX-IV")

    expect_equal(length(res$cells), 5)

  }
  res <- solve_reg_fm_prob(node_info = nodes_shell_fmatch(rownames(d), colnames(d)),
                     distspec = d, max.cpt = max.cpt, min.cpt = min.cpt,
                     tolerance = tolerance, omit.fraction = NULL, solver = "LEMON")

  expect_equal(length(res$cells), 5)

})

test_that("NA is true, not string", {
  expect_warning(f1 <- fullmatch(pr ~ cost, min = 10, data = nuclearplants,
                                 within = exactMatch(pr ~ pt, data = nuclearplants)))
  expect_true(all(is.na(f1)))
})
