% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optmatchS3.R, R/summary.optmatch.R
\name{optmatch}
\alias{optmatch}
\alias{optmatch-class}
\alias{summary.optmatch}
\title{Optmatch Class}
\usage{
\method{summary}{optmatch}(
  object,
  propensity.model = NULL,
  ...,
  min.controls = 0.2,
  max.controls = 5,
  quantiles = c(0, 0.5, 0.95, 1)
)
}
\arguments{
\item{object}{The \code{optmatch} object to summarize.}

\item{propensity.model}{An optional propensity model (the result of
a call to \code{glm}) to use when summarizing the match. If the
\pkg{RItools} package is installed, an additional chi-squared test will
be performed on the average differences between treated and
control units on each variable used in the model. See the
\code{xBalance} function in the \pkg{RItools} package for more
details.}

\item{...}{Additional arguments to pass to \code{xBalance} when
also passing a propensity model.}

\item{min.controls}{To minimize the the display of a groups with
many treated and few controls, all groups with more than 5
treated units will be summarized as \dQuote{5+}. This is the
reciprocal of the default value (1/5 = 0.2). Lower this value to
see more groups.}

\item{max.controls}{Like \code{min.controls} sets maximum group
sized displayed with respect to the number of controls. Raise
this value to see more groups.}

\item{quantiles}{A points in the ECDF at which the distances
between units will be displayed.}
}
\value{
\code{optmatch.summary}
}
\description{
The \code{optmatch} class describes the results of an optimal full matching
(using either \code{\link{fullmatch}} or \code{\link{pairmatch}}). For the
most part, these objects can be treated as \code{factors}.

The summary function quantifies \code{optmatch} objects on the effective sample
size, the distribution of distances between matched units, and how well the
match reduces average differences.
}
\details{
\code{optmatch} objects descend from \code{factor}.
Elements of this vector correspond to members of the treatment and control
groups in reference to which the matching problem was posed, and are named
accordingly; the names are taken from the row and column names of
\code{distance}.  Each element of the vector is either \code{NA}, indicating
unavailability of any suitable matches for that element, or the
concatenation of: (i) a character abbreviation of the name of the subclass
(as encoded using \code{\link{exactMatch}}) (ii) the string \code{.}; and
(iii) a non-negative integer.  In this last place, positive whole numbers
indicate placement of the unit into a matched set and \code{NA} indicates
that all or part of the matching problem given to \code{fullmatch} was found
to be infeasible.  The functions \code{\link{matched}},
\code{\link{unmatched}}, and \code{\link{matchfailed}} distinguish these
scenarios.

Secondarily, \code{fullmatch} returns various data about the matching
process and its result, stored as attributes of the named vector which is
its primary output.  In particular, the \code{exceedances} attribute gives
upper bounds, not necessarily sharp, for the amount by which the sum of
distances between matched units in the result of \code{fullmatch} exceeds
the least possible sum of distances between matched units in a feasible
solution to the matching problem given to \code{fullmatch}.  (Such a bound
is also printed by \code{print.optmatch} and \code{summary.optmatch}.)
}
\seealso{
\code{\link{print.optmatch}}
}
