% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r_fun.R
\name{orbital_r_fun}
\alias{orbital_r_fun}
\title{Turn orbital object into a R function}
\usage{
orbital_r_fun(x, name = "orbital_predict", file)
}
\arguments{
\item{x}{An \link{orbital} object.}

\item{name}{Name of created function. Defaults to `"orbital_predict"``.}

\item{file}{A file name.}
}
\value{
Nothing.
}
\description{
Returns a R file that contains a function that output predictions when
applied to data frames.
}
\details{
The generated function is only expected to work on data frame objects. The
generated function doesn't require the orbital package to be loaded.
Depending on what models and steps are used, other packages such as dplyr
will need to be loaded as well.
}
\examples{
\dontshow{if (rlang::is_installed(c("recipes", "tidypredict", "workflows"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(workflows)
library(recipes)
library(parsnip)

rec_spec <- recipe(mpg ~ ., data = mtcars) |>
  step_normalize(all_numeric_predictors())

lm_spec <- linear_reg()

wf_spec <- workflow(rec_spec, lm_spec)

wf_fit <- fit(wf_spec, mtcars)

orbital_obj <- orbital(wf_fit)

file_name <- tempfile()

orbital_r_fun(orbital_obj, file = file_name)

readLines(file_name)
\dontshow{\}) # examplesIf}
}
