% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osrm_prepare_graph.R
\name{osrm_prepare_graph}
\alias{osrm_prepare_graph}
\title{Prepare OSRM Graph for Routing (Extract + Partition/Contract)}
\usage{
osrm_prepare_graph(
  input_osm,
  profile = osrm_find_profile("car.lua"),
  threads = 8L,
  overwrite = FALSE,
  verbosity = c("INFO", "NONE", "ERROR", "WARNING", "DEBUG"),
  data_version = NULL,
  small_component_size = 1000L,
  with_osm_metadata = FALSE,
  parse_conditional_restrictions = FALSE,
  location_dependent_data = NULL,
  disable_location_cache = FALSE,
  dump_nbg_graph = FALSE,
  algorithm = c("mld", "ch"),
  balance = 1.2,
  boundary = 0.25,
  optimizing_cuts = 10L,
  max_cell_sizes = c(128, 4096, 65536, 2097152),
  quiet = FALSE,
  verbose = FALSE,
  spinner = TRUE,
  echo_cmd = FALSE
)
}
\arguments{
\item{input_osm}{A string. Path to the input OSM file (\code{.osm}, \code{.osm.bz2}, or \code{.osm.pbf}) or a directory containing exactly one OSM file with a supported extension.}

\item{profile}{A string. Path to the OSRM Lua profile (e.g. returned by \code{osrm_find_profile("car.lua")}).}

\item{threads}{An integer. Number of threads for extract and partition/contract; default \code{8}.}

\item{overwrite}{A logical. If \code{FALSE}, stops if any existing \verb{.osrm*} files matching
the base name are found alongside \code{input_osm}. Set to \code{TRUE} to overwrite them.}

\item{verbosity}{A string. Log verbosity for extract/partition/contract
(one of \verb{"NONE","ERROR","WARNING","INFO","DEBUG"}); default \code{"INFO"}.}

\item{data_version}{A string or \code{NULL}. Passed to \code{osrm-extract} via \code{-d}; default \code{NULL}.}

\item{small_component_size}{An integer. For extract & partition; default \code{1000}.}

\item{with_osm_metadata}{A logical. Adds \code{--with-osm-metadata} during extract; default \code{FALSE}.}

\item{parse_conditional_restrictions}{A logical. Adds \code{--parse-conditional-restrictions}; default \code{FALSE}.}

\item{location_dependent_data}{A string or \code{NULL}. Path to GeoJSON for extract; default \code{NULL}.}

\item{disable_location_cache}{A logical. Adds \code{--disable-location-cache}; default \code{FALSE}.}

\item{dump_nbg_graph}{A logical. Adds \code{--dump-nbg-graph}; default \code{FALSE}.}

\item{algorithm}{A string. One of \code{"mld"} (default) or \code{"ch"}.}

\item{balance}{A numeric. Balance for \code{osrm-partition}; default \code{1.2}.}

\item{boundary}{A numeric. Boundary percentage for \code{osrm-partition}; default \code{0.25}.}

\item{optimizing_cuts}{An integer. Optimizing cuts for \code{osrm-partition}; default \code{10}.}

\item{max_cell_sizes}{A numeric vector. Max cell sizes for \code{osrm-partition}; default \code{c(128,4096,65536,2097152)}.}

\item{quiet}{A logical. Master switch that suppresses package messages and
process output when \code{TRUE}; default \code{FALSE}.}

\item{verbose}{A logical. When \code{TRUE} and \code{quiet = FALSE}, streams stdout and
stderr from the underlying \code{processx::run} calls.}

\item{spinner}{A logical. When \code{TRUE} and \code{quiet = FALSE}, shows a spinner
instead of live logs; default \code{TRUE}.}

\item{echo_cmd}{A logical. When \code{TRUE} and \code{quiet = FALSE}, prints each
command before running; default \code{FALSE}.}
}
\value{
An object of class \code{osrm_job} with the following elements:
\describe{
\item{osrm_job_artifact}{The path to the final routing-ready graph file (\code{.osrm.hsgr} for CH or \code{.osrm.mldgr} for MLD).}
\item{osrm_working_dir}{The directory containing all OSRM files.}
\item{logs}{A list of \code{processx::run} results for each stage:
\code{extract}, \code{partition}/\code{contract}, and \code{customize} (if MLD).}
}
}
\description{
High-level wrapper that first runs \code{osrm-extract} on an OSM file
to produce the base \code{.osrm} graph, then prepares it for routing via
either the MLD pipeline (\code{osrm-partition} + \code{osrm-customize}) or the CH pipeline (\code{osrm-contract}).
}
\examples{
\donttest{
if (identical(Sys.getenv("OSRM_EXAMPLES"), "true")) {
  install_dir <- osrm_install(
    version = "latest",
    path_action = "session",
    quiet = TRUE
  )

  # Prepare a routing-ready graph with the default MLD pipeline
  pbf_path <- system.file("extdata/cur.osm.pbf", package = "osrm.backend")
  osrm_dir <- file.path(tempdir(), paste0("osrm-", Sys.getpid()))
  dir.create(osrm_dir, recursive = TRUE)
  tmp_pbf <- file.path(osrm_dir, "cur.osm.pbf")
  file.copy(from = pbf_path, to = tmp_pbf, overwrite = TRUE)

  graph <- osrm_prepare_graph(
    input_osm = tmp_pbf,
    overwrite = TRUE,
    threads = 1L,
    algorithm = "mld"
  )
  graph$osrm_job_artifact

  osrm_uninstall(
    dest_dir = install_dir,
    clear_path = TRUE,
    force = TRUE,
    quiet = TRUE
  )
  unlink(osrm_dir, recursive = TRUE)
}
}

}
