% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ouxy.r
\name{HyperParam}
\alias{HyperParam}
\title{The range of parameters}
\usage{
HyperParam(tree = tree, traitset = traitset)
}
\arguments{
\item{tree}{An ape: tree object stored in phylo format}

\item{traitset}{a dataframe that contains 3 traits}
}
\value{
A list of vectors of sample of model parameters, regression parameter and ancestral values.
}
\description{
Set up range for parameters for next step
}
\details{
Function \code{\link{OUprior}} is called to compute the model estimate, then return the range for parameter estimate for next step analysis. The range is set to 3 times larger/smaller than the parameter estimates.
Function \code{\link{regboundfcn}} is called to get the bound of regression parameter.
The ancestral value (root) is computed for each traits in order to used for simulation in the four functions \code{\link{oubmbmTrait}},\code{\link{ououbmTrait}}, \code{\link{oubmcirTrait}} and \code{\link{ououcirTrait}}.
}
\examples{

## using coral dataset (running time more > 5 sec)
\donttest{
data(coral)
tree<-coral$tree
traitset<-coral$traitset
HyperParam(tree=tree,traitset=traitset)
}
}
