% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience-plots.R
\name{gg_smooth}
\alias{gg_smooth}
\alias{gg_smooth.default}
\title{Plot smooth 1d terms of gam objects}
\usage{
gg_smooth(x, ...)

\method{gg_smooth}{default}(x, fit, ...)
}
\arguments{
\item{x}{A data frame or object of class \code{pamm}.}

\item{...}{Further arguments passed to \code{\link{get_terms}}}

\item{fit}{A model object.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object.
}
\description{
Given a gam model this convenience function returns a plot of all
smooth terms contained in the model. If more than one smooth is present, the
different smooth are faceted.
}
\examples{
g1 <- mgcv::gam(Sepal.Length ~ s(Sepal.Width) + s(Petal.Length), data=iris)
gg_smooth(iris, g1, terms=c("Sepal.Width", "Petal.Length"))
}
\seealso{
get_terms
}
