% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make-newdata.R
\name{make_newdata}
\alias{make_newdata}
\alias{make_newdata.default}
\alias{make_newdata.ped}
\alias{make_newdata.fped}
\title{Construct a data frame suitable for prediction}
\usage{
make_newdata(x, ...)

\method{make_newdata}{default}(x, ...)

\method{make_newdata}{ped}(x, ...)

\method{make_newdata}{fped}(x, ...)
}
\arguments{
\item{x}{A data frame (or object that inherits from \code{data.frame}).}

\item{...}{Covariate specifications (expressions) that will be evaluated
by looking for variables in \code{x} (or \code{data}). Must be of the form \code{z = f(z)}
where \code{z} is a variable in the data set \code{x} and \code{f} a known
function that can be usefully applied to \code{z}. See examples below.}
}
\description{
Given a data set, returns a data set that can be used
as \code{newdata} argument in a call to \code{predict} and similar functions.
The function is particularly useful in combination with one of the
\code{add_*} functions, e.g., \code{\link{add_term}}, \code{\link{add_hazard}},
etc.
}
\details{
Depending on the class of \code{x}, mean or modus values will be
used for variables not specified in ellipsis. If x is an object that inherits
from class \code{ped}, useful data set completion will be attempted depending
on variables specified in ellipsis.
}
\examples{
tumor \%>\% make_newdata()
tumor \%>\% make_newdata(age=c(50))
tumor \%>\% make_newdata(days=seq_range(days, 3), age=c(50, 55))
tumor \%>\% make_newdata(days=seq_range(days, 3), status=unique(status), age=c(50, 55))
# mean/modus values of unspecified variables are calculated over whole data
tumor \%>\% make_newdata(sex=unique(sex))
tumor \%>\% group_by(sex) \%>\% make_newdata()
# You can also pass a part of the data sets as data frame to make_newdata
purrr::cross_df(list(days = c(0, 500, 1000), sex = c("male", "female"))) \%>\%
  make_newdata(x=tumor)

# Examples for PED data
ped <- tumor \%>\% slice(1:3) \%>\% as_ped(Surv(days, status)~., cut = c(0, 500, 1000))
ped \%>\% make_newdata(age=c(50, 55))
# if time information is specified, other time variables will be specified
# accordingly and offset calculated correctly
ped \%>\% make_newdata(tend = c(1000), age = c(50, 55))
ped \%>\% make_newdata(tend = unique(tend))
ped \%>\% group_by(sex) \%>\% make_newdata(tend = unique(tend))
}
