% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varying.R
\name{varying_args.model_spec}
\alias{varying_args.model_spec}
\alias{varying_args.recipe}
\alias{varying_args.step}
\title{Determine varying arguments}
\usage{
\method{varying_args}{model_spec}(object, full = TRUE, ...)

\method{varying_args}{recipe}(object, full = TRUE, ...)

\method{varying_args}{step}(object, full = TRUE, ...)
}
\arguments{
\item{object}{A \code{model_spec} or a \code{recipe}.}

\item{full}{A single logical. Should all possible varying parameters be
returned? If \code{FALSE}, then only the parameters that
are actually varying are returned.}

\item{...}{Not currently used.}
}
\value{
A tibble with columns for the parameter name (\code{name}), whether it
contains \emph{any} varying value (\code{varying}), the \code{id} for the object (\code{id}),
and the class that was used to call the method (\code{type}).
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{varying_args()} takes a model specification or a recipe and returns a tibble
of information on all possible varying arguments and whether or not they
are actually varying.

The \code{id} column is determined differently depending on whether a \code{model_spec}
or a \code{recipe} is used. For a \code{model_spec}, the first class is used. For
a \code{recipe}, the unique step \code{id} is used.
}
\examples{
\dontshow{if (!parsnip:::is_cran_check()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# List all possible varying args for the random forest spec
rand_forest() |> varying_args()

# mtry is now recognized as varying
rand_forest(mtry = varying()) |> varying_args()

# Even engine specific arguments can vary
rand_forest() |>
  set_engine("ranger", sample.fraction = varying()) |>
  varying_args()

# List only the arguments that actually vary
rand_forest() |>
  set_engine("ranger", sample.fraction = varying()) |>
  varying_args(full = FALSE)

rand_forest() |>
  set_engine(
    "randomForest",
    strata = Class,
    sampsize = varying()
  ) |>
  varying_args()
\dontshow{\}) # examplesIf}
}
\keyword{internal}
