% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{tx_to_snomed_coding}
\alias{tx_to_snomed_coding}
\title{Convert SNOMED CT codes to Coding structures}
\usage{
tx_to_snomed_coding(coding_column, version = NULL)
}
\arguments{
\item{coding_column}{The Column containing the codes.}

\item{version}{The version of the code system.}
}
\value{
A Column containing a Coding struct.
}
\description{
Converts a Column containing codes into a Column that contains a SNOMED Coding struct.
}
\details{
The Coding struct Column can be used as an input to terminology functions such as 
\code{\link{tx_member_of}} and \code{\link{tx_translate}}. Please note that inside 
\code{sparklyr} verbs such as \code{mutate} the functions calls need to be preceded with 
\code{!!}, e.g: \code{!!tx_to_coding(CODE, SNOMED_URI)}.
}
\examples{
\dontshow{if (pathling_is_spark_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
pc <- pathling_connect()
condition_df <- pathling_spark(pc) \%>\% sparklyr::copy_to(conditions)

# Convert codes to SNOMED CT codings.
# Equivalent to: tx_to_coding(CODE, "http://snomed.info/sct")
condition_df \%>\% sparklyr::mutate(snomedCoding = !!tx_to_snomed_coding(CODE), .keep = 'none')

pathling_disconnect(pc)
\dontshow{\}) # examplesIf}
}
\seealso{
Other terminology helpers: 
\code{\link{tx_to_coding}()},
\code{\link{tx_to_ecl_value_set}()},
\code{\link{tx_to_loinc_coding}()}
}
\concept{terminology helpers}
