% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAG.R
\name{define_model_set}
\alias{define_model_set}
\title{Define a model set.}
\usage{
define_model_set(..., .common = NULL)
}
\arguments{
\item{...}{Named arguments, which each are a lists of formulas defining the
paths of a causal model.}

\item{.common}{A list of formulas that contain causal paths that are common
to each model.}
}
\value{
A list of models, each of class \code{matrix} and \code{DAG}.
}
\description{
This is a convenience function to quickly and clearly define a set of causal
models. Supply a list of formulas for each model, using either \code{c()}. Formulas
should be of the form \code{child ~ parent} and describe each path in your model.
Multiple children of a single parent can be combined into a single formula:
\code{child ~ parent1 + parent2}.
}
\details{
This function uses \code{\link[ggm:DAG]{ggm::DAG()}}.
}
\examples{
(m <- define_model_set(
  A = c(a~b, b~c),
  B = c(b~a, c~b),
  .common = c(d~a)))
plot_model_set(m)
}
