% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pglmm-plot.R
\name{pglmm.plot.ranef}
\alias{pglmm.plot.ranef}
\alias{pglmm.plot.re}
\alias{communityPGLMM.show.re}
\alias{communityPGLMM.plot.re}
\title{Visualize random terms of communityPGLMMs}
\usage{
pglmm.plot.ranef(formula = NULL, data = NULL, family = "gaussian",
  sp.var = "sp", site.var = "site", tree = NULL, tree_site = NULL,
  repulsion = FALSE, x = NULL, show.image = TRUE,
  show.sim.image = FALSE, random.effects = NULL, add.tree.sp = TRUE,
  add.tree.site = FALSE, cov_ranef = NULL, tree.panel.space = 0.5,
  title.space = 5, tree.size = 3, ...)

communityPGLMM.show.re(formula = NULL, data = NULL,
  family = "gaussian", sp.var = "sp", site.var = "site",
  tree = NULL, tree_site = NULL, repulsion = FALSE, x = NULL,
  show.image = TRUE, show.sim.image = FALSE, random.effects = NULL,
  add.tree.sp = TRUE, add.tree.site = FALSE, cov_ranef = NULL,
  tree.panel.space = 0.5, title.space = 5, tree.size = 3, ...)

pglmm.plot.re(formula = NULL, data = NULL, family = "gaussian",
  sp.var = "sp", site.var = "site", tree = NULL, tree_site = NULL,
  repulsion = FALSE, x = NULL, show.image = TRUE,
  show.sim.image = FALSE, random.effects = NULL, add.tree.sp = TRUE,
  add.tree.site = FALSE, cov_ranef = NULL, tree.panel.space = 0.5,
  title.space = 5, tree.size = 3, ...)

communityPGLMM.plot.re(formula = NULL, data = NULL,
  family = "gaussian", sp.var = "sp", site.var = "site",
  tree = NULL, tree_site = NULL, repulsion = FALSE, x = NULL,
  show.image = TRUE, show.sim.image = FALSE, random.effects = NULL,
  add.tree.sp = TRUE, add.tree.site = FALSE, cov_ranef = NULL,
  tree.panel.space = 0.5, title.space = 5, tree.size = 3, ...)
}
\arguments{
\item{formula}{A two-sided linear formula object describing the
mixed effects of the model.

To specify that a random term should have phylogenetic covariance matrix along
with non-phylogenetic one, add \code{__} (two underscores) at the end of the group variable;
e.g., \code{+ (1 | sp__)} will construct two random terms,
one with phylogenetic covariance matrix and another with non-phylogenetic (identity) matrix.
In contrast, \code{__} in the nested terms (below) will only create a phylogenetic covariance matrix.
Nested random terms have the general form \code{(1|sp__@site__)} which represents
phylogenetically related species nested within correlated sites.
This form can be used for bipartite questions. For example, species could be
phylogenetically related pollinators and sites could be phylogenetically related plants, leading to
the random effect \code{(1|insects__@plants__)}. If more than one phylogeny is used, remember to add
all to the argument \code{cov_ranef = list(insects = insect_phylo, plants = plant_phylo)}. Phylogenetic correlations can
be dropped by removing the \code{__} underscores. Thus, the form \code{(1|sp@site__)} excludes the phylogenetic
correlations among species, while the form \code{(1|sp__@site)} excludes the correlations among sites.

Note that correlated random terms are not allowed. For example,
\code{(x|g)} will be the same as \code{(0 + x|g)} in the \code{lme4::lmer} syntax. However,
\code{(x1 + x2|g)} won't work, so instead use  \code{(x1|g) + (x2|g)}.}

\item{data}{A \code{\link{data.frame}} containing the variables named in formula.}

\item{family}{Either "gaussian" for a Linear Mixed Model, or
"binomial" or "poisson" for Generalized Linear Mixed Models.
"family" should be specified as a character string (i.e., quoted). For binomial and
Poisson data, we use the canonical logit and log link functions, respectively.
Binomial data can be either presence/absence, or a two-column array of 'successes' and 'failures'.
For both binomial  and Poisson data, we add an observation-level
random term by default via \code{add.obs.re = TRUE}. If \code{bayes = TRUE} there are
two additional families available: "zeroinflated.binomial", and "zeroinflated.poisson",
which add a zero inflation parameter; this parameter gives the probability that the response is
a zero. The rest of the parameters of the model then reflect the "non-zero" part part
of the model. Note that "zeroinflated.binomial" only makes sense for success/failure
response data.}

\item{sp.var}{The variable name of "species"; y-axis of the image.}

\item{site.var}{The variable name of "site"; x-axis of the image.}

\item{tree}{A phylogeny for column sp, with "phylo" class, or a covariance matrix for sp.
Make sure to have all species in the matrix; if the matrix is not standardized,
(i.e., det(tree) != 1), \code{pglmm} will try to standardize it for you.
No longer used: keep here for compatibility.}

\item{tree_site}{A second phylogeny for "site". This is required only if the
site column contains species instead of sites. This can be used for bipartitie
questions; tree_site can also be a covariance matrix. Make sure to have all sites
in the matrix; if the matrix is not standardized (i.e., det(tree_site) != 1),
pglmm` will try to standardize it for you. No longer used: keep here for compatibility.}

\item{repulsion}{When there are nested random terms specified, \code{repulsion = FALSE} tests
for phylogenetic underdispersion while \code{repulsion = FALSE} tests for overdispersion.
This argument is a logical vector of length either 1 or >1.
If its length is 1, then all covariance matrices in nested terms will be either
inverted (overdispersion) or not. If its length is >1, then you can select
which covariance matrix in the nested terms to be inverted. Make sure to get
the length right: for all the terms with \code{@}, count the number of "__"
to determine the length of repulsion. For example, \code{sp__@site} and \code{sp@site__}
will each require one element of \code{repulsion}, while \code{sp__@site__} will take two
elements (repulsion for sp and repulsion for site). Therefore, if your nested terms are
\code{(1|sp__@site) + (1|sp@site__) + (1|sp__@site__)}, then you should set the
repulsion to be something like \code{c(TRUE, FALSE, TRUE, TRUE)} (length of 4).}

\item{x}{A fitted model with class communityPGLMM.}

\item{show.image}{Whether to show the images of random effects.}

\item{show.sim.image}{Whether to show the images of simulated site by sp matrix.
This can be useful to see how the phylogenetic information were included.}

\item{random.effects}{Optional pre-build list of random effects. If \code{NULL} (the default),
the function \code{\link{prep_dat_pglmm}} will prepare the random effects for you from the information
in \code{formula}, \code{data}, and \code{cov_ranef}. \code{random.effect} allows a list of
pre-generated random effects terms to increase flexibility; for example, this makes it
possible to construct models with both phylogenetic correlation and spatio-temporal autocorrelation.
In preparing \code{random.effect}, make sure that the orders of rows and columns of
covariance matrices in the list are the same as their corresponding group variables
in the data.}

\item{add.tree.sp}{Whether to add a phylogeny of species at the top of the
simulated site by sp matrix plot, default is TRUE.}

\item{add.tree.site}{Whether to add a phylogeny of sites at the right of the
simulated site by sp matrix plot, default is FALSE.}

\item{cov_ranef}{A named list of covariance matrices of random terms. The names should be the
group variables that are used as random terms with specified covariance matrices
(without the two underscores, e.g. \code{list(sp = tree1, site = tree2)}). The actual object
can be either a phylogeny with class "phylo" or a prepared covariance matrix. If it is a phylogeny,
\code{pglmm} will prune it and then convert it to a covariance matrix assuming Brownian motion evolution.
\code{pglmm} will also standardize all covariance matrices to have determinant of one. Group variables
will be converted to factors and all covariance matrices will be rearranged so that rows and
columns are in the same order as the levels of their corresponding group variables.}

\item{tree.panel.space}{The number of lines between the phylogeny and
the matrix plot, if add.tree is TRUE.}

\item{title.space}{The number of lines between the title and the matrix plot, if add.tree is TRUE.}

\item{tree.size}{The height of the phylogeney to be plotted (number of lines), if add.tree is TRUE.}

\item{...}{Additional arguments for \code{Matrix::image()} or \code{lattice::levelplot()}.
Common ones are:
\itemize{
\item \code{useAbs} whether to use absolute values of the matrix; if no negative values,
this will be set to TRUE if not specified. When \code{useAbs = TRUE} the color scheme
will be black-white, otherwise, it will be red/blue.
\item \code{colorkey} whether to draw the scale legend at the right side of each plot?
}}
}
\value{
A hidden list, including the covariance matrices and simulated site by species matrices.
Individual plots are saved as \code{plt_re_list} and \code{plt_sim_list}. If \code{show.image} or
\code{show.sim.image} is TRUE, the corresponding final plot (\code{plt_re_all_in_one} or
\code{plt_sim_all_in_one}) can be saved as external file using \code{ggplot2::ggsave} as
it is a grid object.
}
\description{
Plot variance-cov matrix of random terms; also it is optional to simulate and
visualize data based on these var-cov matrices. The input can be a communityPGLMM
model (by setting argument \code{x}). If no model has been fitted, you can also specify
data, formula, and family, etc. without actually fitting the model, which will
save time.
}
