% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/board_registration.R
\name{board_register_dospace}
\alias{board_register_dospace}
\title{Register DigitalOcean Board}
\usage{
board_register_dospace(
  name = "dospace",
  space = Sys.getenv("DO_SPACE"),
  key = Sys.getenv("DO_ACCESS_KEY_ID"),
  secret = Sys.getenv("DO_SECRET_ACCESS_KEY"),
  datacenter = Sys.getenv("DO_DATACENTER"),
  cache = board_cache_path(),
  host = "digitaloceanspaces.com",
  ...
)
}
\arguments{
\item{name}{Optional name for this board, defaults to 's3'.}

\item{space}{The name of the DigitalOcean space. Defaults to the \code{DO_SPACE} environment
variable.}

\item{key}{The key of the DigitalOcean space. Defaults to the \code{DO_ACCESS_KEY_ID} environment
variable.}

\item{secret}{The secret of the DigitalOcean space. Defaults to the \code{DO_SECRET_ACCESS_KEY} environment
variable.}

\item{datacenter}{The datacenter of the DigitalOcean space. Defaults to the \code{DO_DATACENTER} environment
variable.}

\item{cache}{The local folder to use as a cache, defaults to \code{board_cache_path()}.}

\item{host}{The host to use for storage, defaults to \code{"digitaloceanspaces.com"}.}

\item{...}{Additional parameters required to initialize a particular board.}
}
\description{
Wrapper with explicit parameters over \code{board_register()} to
register a DigitalOcean Spaces board.
}
\details{
This function requires a DigitalOcean space to be manually created; otherwise,
registering a DigitalOcean space will fail.
}
\examples{
\dontrun{
# the following example requires a DigitalOcean Spaces API key
board_register_s3(bucket = "s3bucket")
}
}
\seealso{
board_register
}
