% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLambda.R
\name{getLambda}
\alias{getLambda}
\title{Calculates lambda, the population growth rate, for each species in a quadrat
based on changes in basal cover.}
\usage{
getLambda(
  dat,
  inv,
  method = "area",
  species = "Species",
  quad = "Quad",
  site = "Site",
  year = "Year",
  geometry = "geometry",
  ...
)
}
\arguments{
\item{dat}{An sf data.frame in which each row represents a unique polygon
(either a genet or a ramet) in a unique site/quadrat/year combination. A
data.frame returned by \code{\link{trackSpp}} can be put directly into this
function. However, it is not strictly necessary for 'dat' to have demographic
data or unique identifiers (i.e. 'trackIDs') assigned. If there are not
trackIDs assigned for each individual, then the function assumes that each
row of data repesents one genetic individual.'dat' \emph{must} have columns that
contain...
\itemize{
\item a unique identification for each research site in character format
with no NAs (the default column name is "Site")
\item species name in character format with no NAs (the default column
name is "Species")
\item unique quadrat identifier in character format with no NAs (the default
column name is "Quad")
\item year of data collection in integer format with no NAs (the
default column name is "Year")
\item an s.f 'geometry' column that contains a polygon or multipolygon data type
for each individual observation (the default column name is "geometry")
}}

\item{inv}{The name of each element of the list is a
quadrat name in 'dat', and the contents of that list element is a numeric
vector of all of the years in which that quadrat (or other unique spatial
area) was sampled. Make sure this is the years the quadrat was actually
sampled, not just the years that have data in the 'dat' argument! This
argument allows the function to differentiate between years when the quadrat
wasn't sampled and years when there just weren't any individuals of a species
present in that quadrat.}

\item{method}{A single character argument that determines the method for
calculating lambda. The default value is "area", which means that lambda is
calculated by comparing total basal area for a given species in year t+1 to
year t. If 'method' = "count", then lambda is calculated by comparing total
number of individuals for a given species in year t+1 to year t. If each
individual in 'dat' is mapped as a point, it is best to use
'method' = "count".}

\item{species}{An optional character string argument. Indicates
the name of the column in 'dat' that contains species name data. It is
unnecessary to include a value for this argument if the column name is
"Species" (default value is 'Species').}

\item{quad}{An optional character string argument. Indicates
the name of the column in 'dat' that contains quadrat name data. It is
unnecessary to include a value for this argument if the column name is
"Quad" (default is 'Quad').}

\item{site}{An optional character string argument. Indicates
the name of the column in 'dat' that contains site name data. It is
unnecessary to include a value for this argument if the column name is
"Site" (default value is 'Site').}

\item{year}{An optional character string argument. Indicates
the name of the column in 'dat' that contains data for year of sampling. It
is unnecessary to include a value for this argument if the column name is
"Year" (default is 'Year').}

\item{geometry}{An optional character string argument. Indicates
the name of the column in 'dat' that contains sf geometry data. It is
unnecessary to include a value for this argument if the column name is
"geometry" (default is 'geometry').}

\item{...}{Other arguments passed on to methods. Not currently used.}
}
\value{
This function returns a data.frame with columns containing site,
quadrat, and species data, as well as the following columns:
\describe{
\item{Year_t}{the 'current' year}
\item{absolute_basalArea_t}{basal area (in the same units as the spatial
elements of 'dat') for this species in this quadrat in year 't'}
\item{Year_tplus1}{the 'next' year}
\item{absolute_basalArea_tplus1}{basal area (in the same units as the spatial
elements of 'dat') for this species in this quadrat in year 't+1'}
\item{lambda}{The population growth rate for this species in this quadrat
from year t to year t+1.}
}
}
\description{
This function calculates the population growth rate (lambda) for
every species in a quadrat. This value is the ratio of basal area or number
of individuals in the next year to basal area or number of individuals in the
current year (basal area in year t+1/ basal area in year t). A lambda value
greater than 1 indicates a population is growing, while a value less than 1
indicates population decline. Lambda is 'infinity' when the basal area or
number of individuals in year t is 0, and is NA when basal area or number of
individuals in year t is zero (i.e. when there are no organims present in
year =t). Note that a lambda value is calculated between of the years when a
quadrat was sampled, even if there is a gap in sampling. For example, a
quadrat is sampled in 1998, 1999, 2001, and 2002 (but skipped in 2000). A
lambda value will be calculated for 1998-1999 and 2001-2002, which is a
transition from year \code{t} to year \code{t+1}. However, a lambda value is calculated
in the same manner for 1999-2001, which is actually a transition from year
\code{t} to year \code{t+2}. You can remove these values by subsetting the data.frame
returned by \code{getLambda()} for rows when "Year_tplus1"- "Year_t" is equal
to 1.
}
\examples{
dat <- grasslandData[grasslandData$Site == "AZ" &
 grasslandData$Year \%in\% c(1922:1925),]
names(dat)[1] <- "speciesName"
inv <- grasslandInventory[unique(dat$Quad)]
outDat <- trackSpp(dat = dat,
 inv = inv,
 dorm = 1,
 buff = .05,
 buffGenet = 0.005,
 clonal = data.frame("Species" = unique(dat$speciesName),
 "clonal" = c(TRUE,FALSE)),
 species = "speciesName",
 aggByGenet = TRUE
 )
getLambda(dat = outDat, inv = inv, method = "area",
species = "speciesName")
}
\seealso{
\code{\link[=getBasalAreas]{getBasalAreas()}}, used internally in this function, which
calculates absolute and relative basal areas for each species in each quadrat
for each year of sampling.
}
