% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpatialModel.R
\name{SpatialModel}
\alias{SpatialModel}
\title{R6 class representing a spatial model}
\description{
\code{\link[R6:R6Class]{R6}} class representing a generic (abstract)
spatially-explicit model. It extends \code{\link{GenericModel}} with the addition of
a study region specification.
}
\examples{
# U Island example region
coordinates <- data.frame(
  x = rep(seq(177.01, 177.05, 0.01), 5),
  y = rep(seq(-18.01, -18.05, -0.01), each = 5)
)
template_raster <- Region$new(coordinates = coordinates)$region_raster # full extent
template_raster[][-c(7, 9, 12, 14, 17:19)] <- NA # make U Island
region <- Region$new(template_raster = template_raster)
# Example spatial model
model1 <- SpatialModel$new(region = region, a_layers = 3)
model1$coordinates
model1$set_attributes(a_values = array(8:28, c(7, 3)))
model1$region$raster_from_values(model1$get_attribute("a_values"))

}
\section{Super classes}{
\code{\link[poems:GenericClass]{poems::GenericClass}} -> \code{\link[poems:GenericModel]{poems::GenericModel}} -> \code{SpatialModel}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{attached}}{A list of dynamically attached attributes (name-value pairs).}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{model_attributes}}{A vector of model attribute names.}

\item{\code{region}}{A \code{\link{Region}} (or inherited class) object specifying the study region.}

\item{\code{coordinates}}{Data frame (or matrix) of X-Y population (WGS84) coordinates in longitude (degrees West) and latitude (degrees North) (get and set), or distance-based coordinates dynamically returned by region raster (get only).}

\item{\code{attribute_aliases}}{A list of alternative alias names for model attributes (form: \code{alias = "attribute"}) to be used with the set and get attributes methods.}

\item{\code{error_messages}}{A vector of error messages encountered when setting model attributes.}

\item{\code{warning_messages}}{A vector of warning messages encountered when setting model attributes.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SpatialModel-new}{\code{SpatialModel$new()}}
\item \href{#method-SpatialModel-new_clone}{\code{SpatialModel$new_clone()}}
\item \href{#method-SpatialModel-clone}{\code{SpatialModel$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="poems" data-topic="GenericModel" data-id="get_attribute"><a href='../../poems/html/GenericModel.html#method-GenericModel-get_attribute'><code>poems::GenericModel$get_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="GenericModel" data-id="get_attribute_aliases"><a href='../../poems/html/GenericModel.html#method-GenericModel-get_attribute_aliases'><code>poems::GenericModel$get_attribute_aliases()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="GenericModel" data-id="get_attribute_names"><a href='../../poems/html/GenericModel.html#method-GenericModel-get_attribute_names'><code>poems::GenericModel$get_attribute_names()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="GenericModel" data-id="get_attributes"><a href='../../poems/html/GenericModel.html#method-GenericModel-get_attributes'><code>poems::GenericModel$get_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="GenericModel" data-id="set_attributes"><a href='../../poems/html/GenericModel.html#method-GenericModel-set_attributes'><code>poems::GenericModel$set_attributes()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpatialModel-new"></a>}}
\if{latex}{\out{\hypertarget{method-SpatialModel-new}{}}}
\subsection{Method \code{new()}}{
Initialization method sets given attributes individually and/or from a list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpatialModel$new(region = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{region}}{A \code{\link{Region}} (or inherited class) object specifying the study region.}

\item{\code{...}}{Parameters passed individually.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpatialModel-new_clone"></a>}}
\if{latex}{\out{\hypertarget{method-SpatialModel-new_clone}{}}}
\subsection{Method \code{new_clone()}}{
Creates a new (re-initialized) object of the current (inherited) object class with optionally passed parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpatialModel$new_clone(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Parameters passed via the inherited class constructor (defined in initialize and run via new).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
New object of the current (inherited) class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpatialModel-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SpatialModel-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpatialModel$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
