% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_ABC.R
\name{Tmatrix}
\alias{Tmatrix}
\title{Transform matrix of parameter values}
\usage{
Tmatrix(original, limits)
}
\arguments{
\item{original}{a matrix of parameter values i.e. numbers obtained from the
simulations. Each column should be a different parameter and each row a
different simulation. This is the matrix that you wish to transform so that
the parameter values are all in the same scale.}

\item{limits}{is a matrix with two columns and as many rows as there are
parameters. Each row should contain the minimum value of the prior for a
given parameter in the first column and the maximum value in the second
column.}
}
\value{
a matrix with the same dimensions as the \code{original} matrix but
with the parameter values transformed.
}
\description{
This function applies a transformation to the parameter values.
}
\details{
The transformation should be applied before parameter estimation using an
Approximate Bayesian Computation framework to ensure that the estimates do
not fall outside the boundaries set by the prior distribution.
}
\keyword{internal}
