% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_sumstats.R
\name{pairFST}
\alias{pairFST}
\title{Pairwise FST among populations}
\usage{
pairFST(nPops, Pop_pi, coverage)
}
\arguments{
\item{nPops}{is an integer indicating how many populations are present in the
data.}

\item{Pop_pi}{is a matrix of allele frequencies. Each row of that matrix
should correspond to a different population and each column to a different
site.}

\item{coverage}{is a matrix containing depths of coverage. Each row of that
matrix should correspond to a different population and each column to a
different site.}
}
\value{
a upper triangular matrix with the pairwise FST values between each
population.
}
\description{
This functions calculates pairwise FST values according to Hudson's estimator
following Bathia. FST values are calculated for each pairwise combination of
the populations present in the data (defined by the \code{nPops} parameter).
}
\details{
This functions performs pairwise comparisons of multiple populations and thus
returns multiple FST values, one for each comparison. However, this function
computes FST for a single locus.
}
\keyword{internal}
