% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_ABC.R
\name{plot_param}
\alias{plot_param}
\title{Plot the density estimation of a given parameter}
\usage{
plot_param(prior, posterior, limits, index, weights = NULL)
}
\arguments{
\item{prior}{is a vector or matrix of simulated parameter values i.e. numbers
from the simulations. Each row or vector entry should be a different
simulation and each column of a matrix should be a different parameter.
This corresponds to the prior distribution and it should contain all the
simulated parameter values.}

\item{posterior}{is either a list or a matrix with samples from the posterior
distributions obtained for each target. If in list format, each entry
should be a matrix where each row corresponds to a different accepted
simulations and each column corresponds to a different parameter.}

\item{limits}{is a matrix with two columns and as many rows as there are
parameters. Each row should contain the minimum value of the prior for a
given parameter in the first column and the maximum value in the second
column.}

\item{index}{is an non-negative integer indicating which parameter to plot.
It corresponds to the desired column of a matrix in the \code{posteriors} input.
So, to plot the first parameter, corresponding to the first column in the
\code{posteriors} input select 1. To plot the second parameter, select 2 and so
on.}

\item{weights}{is an optional list input containing the weights from the
local linear regression method. Each entry of the list should be a numeric
vector with the weights for each accepted simulation.}
}
\value{
a plot of the density estimation of a given parameter. This plot will
include a title with the name of the parameter. It will also include the
density of the prior distribution for that parameter.
}
\description{
Plots the density estimation of a single parameter for quick visualization of
the quality of an ABC analysis.
}
\details{
This function can be used for a quick visualization of the posterior
distribution obtained for a single target with the \code{\link[=singleABC]{singleABC()}} function.
Alternatively, if parameter estimation was performed with the \code{\link[=multipleABC]{multipleABC()}}
function, the multiple posterior distributions, each obtained for a different
target, will be combined into a single matrix and all values will be
considered samples from the same posterior distribution.
}
\examples{
# load the matrix with parameter values
data(params)
# load the matrix with simulated parameter values
data(sumstats)
# load the matrix with the prior limits
data(limits)

# select a random simulation to act as target just to test the function
target <- sumstats[15 ,]
# we should remove the random simulation from the sumstats and params matrices
sumstats <- sumstats[-15, ]; params <- params[-15, ]

# parameter estimation for a single target
myabc <- singleABC(target = target, params = params, sumstats = sumstats, limits = limits,
tol = 0.01, method = "regression")

# plot the density estimation of a given parameter
plot_param(prior = params, posterior = myabc$adjusted, limits = limits,
index = 6, weights = myabc$weights)

# note that this is just an example!
# we don't have enough simulations to obtain credible results

}
