% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_simulations.R
\name{poolSim}
\alias{poolSim}
\title{Simulation of Pooled DNA sequencing}
\usage{
poolSim(
  model,
  nDip,
  nPops,
  size,
  nLoci,
  nSites,
  mutrate,
  mean,
  variance,
  minimum,
  maximum,
  min.minor = NA,
  Nref,
  ratio,
  split,
  pool,
  seq,
  CW = NA,
  WC = NA,
  CC = NA,
  WW = NA,
  ANC = NA,
  bT = NA,
  bCW = NA,
  bWC = NA,
  force = FALSE
)
}
\arguments{
\item{model}{a character, either 2pops", "Single" or "Parallel" indicating
which model should be simulated.}

\item{nDip}{an integer representing the total number of diploid individuals
to simulate. Note that scrm actually simulates haplotypes, so the number of
simulated haplotypes is double of this. Also note that this is the total
number of diploid individuals and this function will distribute the
individuals equally by the simulated populations.}

\item{nPops}{An integer, representing the total number of populations of the
simulated model.}

\item{size}{a list with one entry per population. Each entry should be a
vector containing the size (in number of diploid individuals) of each pool.
Thus, if a population was sequenced using a single pool, the vector should
contain only one entry. If a population was sequenced using two pools, each
with 10 individuals, this vector should contain two entries and both will
be 10.}

\item{nLoci}{an integer that represents how many independent loci should be
simulated.}

\item{nSites}{is an integer that specifies how many base pairs should scrm
simulate, i.e. how many sites per locus to simulate.}

\item{mutrate}{an integer representing the mutation rate assumed for the
simulations.}

\item{mean}{an integer or a vector defining the mean value of the negative
binomial distribution from which different number of reads are drawn. It
represents the mean coverage across all sites. If a vector is supplied, the
function assumes that each entry of the vector is the mean for a different
population.}

\item{variance}{an integer or a vector defining the variance of the negative
binomial distribution from which different number of reads are drawn. It
represents the variance of the total coverage across all sites. If a vector
is supplied, the function assumes that each entry of the vector is the
variance for a different population.}

\item{minimum}{an integer representing the minimum coverage allowed. Sites
where any population has a depth of coverage below this threshold are
removed from the data.}

\item{maximum}{an integer representing the maximum coverage allowed. Sites
where any population has a depth of coverage above this threshold are
removed from the data.}

\item{min.minor}{is an integer representing the minimum allowed number of
minor-allele reads. Sites that, across all populations, have less
minor-allele reads than this threshold will be removed from the data.}

\item{Nref}{is the minimum and maximum value of the uniform distribution for
the effective population size of the reference population (Nref).}

\item{ratio}{is the minimum and maximum value of the distribution from which
the relative size of the present-day and ancestral populations are drawn.
The size of these populations is set as a ratio of the size of the Nref
population. All of these ratios are drawn from a log10 uniform
distribution.}

\item{split}{is the minimum and maximum values, at the 4Nref scale, of the
uniform distribution from which the values of the times of the split events
are draw. Both the time of the recent split event and the distance between
the two split events are drawn from this distribution.}

\item{pool}{is the the minimum and maximum values of the uniform distribution
from which the value of the error associated with DNA pooling is drawn.
More specifically, this value is related with the unequal individual
contribution to the pool. This parameter should be supplied as a decimal
number between zero and one.}

\item{seq}{is the minimum and maximum values of the uniform distribution from
which the value of the error associated with DNA sequencing is drawn. This
parameter should be supplied as a decimal number between zero and one.}

\item{CW}{is the minimum and maximum value of the uniform distribution from
which the migration rate between the two divergent ecotypes inhabiting the
same location is drawn. We consider that this parameter is drawn on a m
scale. This is the migration rate from ecotype C to ecotype W.}

\item{WC}{is the minimum and maximum value of the uniform distribution from
which the migration rate between the two divergent ecotypes inhabiting the
same location is drawn. We consider that this parameter is drawn on a m
scale. This is the migration rate from ecotype W to ecotype C.}

\item{CC}{is the minimum and maximum value of the uniform distribution from
which the migration rate between similar ecotypes inhabiting different
locations is drawn. We consider that this parameter is drawn on a m scale.
This is the migration between the two C ecotypes at two different
locations.}

\item{WW}{is the minimum and maximum value of the uniform distribution from
which the migration rate between similar ecotypes inhabiting different
locations is drawn. We consider that this parameter is drawn on a m scale.
This is the migration between the two W ecotypes at two different
locations.}

\item{ANC}{is the minimum and maximum value of the uniform distribution from
which the migration rate between similar ecotypes inhabiting different
locations is drawn. We consider that this parameter is drawn on a m scale.
This is the migration between the two W ecotypes at two different
locations.}

\item{bT}{is the minimum and maximum values of the distribution from which
the proportion of the simulated loci where no migration occurs between
divergent ecotypes is drawn. The maximum value should not be higher than
one.}

\item{bCW}{is the minimum and maximum values of the distribution from which
the proportion of the simulated loci where no migration occurs from the C
ecotype towards the W ecotype is drawn. The maximum value should not be
higher than one.}

\item{bWC}{is the minimum and maximum values of the distribution from which
the proportion of the simulated loci where no migration occurs from the W
ecotype towards the C ecotype is drawn. The maximum value should not be
higher than one.}

\item{force}{is a logical value indicating whether the required number of
loci should be enforced. The default is FALSE but, if set to TRUE, then
additional loci will be simulated. These additional loci are simulated to
try to have sufficient loci to keep the required number of loci after
filtering.}
}
\value{
a list with several named entries. The number of entries depends of
the chosen model.

\item{Nref}{numeric, sampled value from the prior for the effective
population size of the reference population.}

\item{N1}{numeric, sampled value from the prior for the relative size of
the present-day populations. This is the relative size of the first
population.}

\item{N2}{numeric, sampled value from the prior for the relative size of
the present-day populations. This is the relative size of the second
population.}

\item{N3}{numeric, sampled value from the prior for the relative size of
the present-day populations. This is the relative size of the third
population. This entry only exists when the selected model has four
populations.}

\item{N4}{numeric, sampled value from the prior for the relative size of
the present-day populations. This is the relative size of the fourth
population. This entry only exists when the selected model has four
populations.}

\item{NA1}{numeric, sampled value from the prior for the relative size of
the ancestral populations. This is the relative size of the ancestral
population of N1 and N2. This entry only exists when the selected model has
four populations.}

\item{NA2}{numeric, sampled value from the prior for the relative size of
the ancestral populations. This is the relative size of the ancestral
population of N3 and N4. This entry only exists when the selected model has
four populations.}

\item{Split}{numeric, sampled value from the prior for the time, in 4Nref
scale, of the recent split event.}

\item{Dsplit}{numeric, sampled value from the prior for the time, in 4Nref
scale, of the distance between the two split events.}

\item{PoolError}{numeric, sampled value from the prior for the error
associated with DNA pooling.}

\item{SeqError}{numeric, sampled value from the prior for the error
associated with DNA sequencing.}

\item{mCW1}{numeric, sampled value from the prior for the migration rate
between the two divergent ecotypes inhabiting the first location. This is
the migration rate from ecotype C to ecotype W. For a two population model,
this entry will be called mCW because that model considers a single
location.}

\item{mCW2}{numeric, sampled value from the prior for the migration rate
between the two divergent ecotypes inhabiting the second location. This is
the migration rate from ecotype C to ecotype W. For a two population model,
this entry will not exist.}

\item{mWC1}{numeric, sampled value from the prior for the migration rate
between the two divergent ecotypes inhabiting the first location. This is
the migration rate from ecotype W to ecotype C. For a two population model,
this entry will be called mWC because that model considers a single
location.}

\item{mWC2}{numeric, sampled value from the prior for the migration rate
between the two divergent ecotypes inhabiting the second location. This is
the migration rate from ecotype W to ecotype C. For a two population model,
this entry will not exist.}

\item{mCC}{numeric, sampled value from the prior for the migration rate
between similar ecotypes inhabiting different locations. This is the
migration between the two C ecotypes at two different locations. For a two
population model, this entry will not exist.}

\item{mWW}{numeric, sampled value from the prior for the migration rate
between similar ecotypes inhabiting different locations. This is the
migration between the two W ecotypes at two different locations. For a two
population model, this entry will not exist.}

\item{mAA}{numeric, sampled value from the prior for the migration rate
between the two ancestral populations. For a two population model, this
entry will not exist.}

\item{pM}{numeric, sampled value from the prior for the proportion of the
genome with no barriers against gene flow. This is the proportion of
simulated loci where migration occurs in both directions between the
divergent ecotypes.}

\item{pCW}{numeric, sampled value from the prior for the proportion of the
genome where no migration occurs from the C ecotype towards the W ecotype.
This is the proportion of simulated loci where migration occurs only from W
towards C. This entry does not exist for the two populations model.}

\item{pWC}{numeric, sampled value from the prior for the proportion of the
genome where no migration occurs from the W ecotype towards the C ecotype.
This is the proportion of simulated loci where migration occurs only from C
towards W. This entry does not exist for the two populations model.}

\item{pNO}{numeric, sampled value from the prior for the proportion of the
genome with no gene flow between divergent ecotypes. This is the proportion
of simulated loci where migration does not occur in both directions between
the C and W ecotypes.}

\item{nPoly}{numeric, mean number of polymorphic sites across all simulated
locus.}

\item{nFilter}{numeric, mean number of polymorphic sites retained after
filtering across all simulated locus.}

\item{nLoci}{numeric, total number of loci retained after filtering.
Summary statistics are calculated for these loci.}

\item{Sf}{numeric, fraction of sites fixed between populations. For the
model with two populations, this is a single value. For the four-population
models, this includes three values: the first is the fraction of fixed
sites between the two populations in the first location, the second value
is between the populations in the second location and the third value is
the overall fraction of fixed sites, obtained by comparing each population
against the other three.}

\item{Sx}{numeric, fraction of exclusive sites per population. When running
the model with two populations, this entry has two values - one per
population. For the four-population models, there is also one value per
population, followed by a fifth value representing the fraction of sites
that are segregating in only one of the populations.}

\item{SS}{numeric values representing the fraction of sites shared between
populations. For the model with two populations, this is a single value.
When running one of the four-population models, this entry has three
values. The first is the fraction of shared sites between the two
populations in the first location, the second value is between the
populations in the second location and the third value is the fraction of
shared sites across all four populations.}

\item{Mean_Het}{numeric, expected heterozygosity within each population.
This entry has two values when using a two populations model and four when
running one of the four-populations model.}

\item{SD_Het}{numeric, standard deviation of the expected heterozygosity
for each population. This entry has two values when using a two populations
model and four when running one of the four-populations model.}

\item{Mean_HetBet}{numeric, mean heterozygosity between all pairs of
populations. For the two populations model, this is a single value
representing the heterozygosity between the two populations. For the
four-population models, this entry includes six values. The first value is
the heterozygosity between the first and the second population, the second
value is between the first and the third population, the third value is
between the first and fourth population, the fourth value is between the
second and third populations, the fifth value is between the second and
fourth population and the sixth value is between the third and fourth
populations.}

\item{SD_HetBet}{numeric, standard deviation of the mean heterozygosity
between all pairs of populations. For the two populations model, this is a
single value representing the standard deviation of heterozygosity between
the two populations. When running one of the four-population models, this
entry includes six values. The order of those entries is the same as for
\code{Mean_HetBet}.}

\item{Mean_FST}{numeric, mean pairwise FST between populations. For the two
populations model, this is a single value representing the mean FST between
the two populations. For the four-population models, this entry includes
six values. The first value is the mean FST between the first and second
populations, the second is between the first and third population, the
third is between the second and third populations, the fourth is between
the first and fourth populations, the fifth value is between the second and
fourth populations and the sixth is between the third and fourth
populations.}

\item{SD_FST}{numeric, standard deviation of the mean pairwise FST between
populations. For the two populations model, this is a single value
representing the standard deviation of the FST between the two populations.
When running one of the four-population models, this entry includes six
values. The order of those entries is the same as for \code{Mean_FST}.}

\item{FSTQ1}{numeric, it is the 5\% quantile of the mean pairwise FST
distribution. For the two populations model, this is a single value
representing the 5\% quantile of the FST between the two populations. When
running one of the four-population models, this entry includes six values.
The order of those entries is the same as for \code{Mean_FST}.}

\item{FSTQ2}{numeric, it is the 95\% quantile of the mean pairwise FST
distribution. For the two populations model, this is a single value
representing the 95\% quantile of the FST between the two populations. For
the four-population models, this entry includes six values. The order of
those entries is the same as for \code{Mean_FST}.}

\item{Dstat}{numeric, value of D-statistic for various combinations of
populations. This entry only exists if a four-population model was
selected. It includes three different values. For the first value, P1 was
the W ecotype in the first location P2 was the W ecotype in the second
location and P3 was the C ecotype at the first location. For the second
value P1 was again the W ecotype in the first location but P2 was the C
ecotype in the second ecotype and P3 was the C ecotype at the first
location. For the third value, P1 was also the W ecotype at the first
location, P2 was the C ecotype at the first location and P3 was the W
ecotype at the second location. For all combinations, P4 was assumed to be
an outgroup fixed, at all sites, for the major allele.}

\item{SD_dstat}{numeric, standard deviation of D-statistic for various
combinations of populations. This entry only exists if a four-population
model was selected. Each entry is the standard deviation of the
corresponding D-statistic in the \code{Dstat} entry.}
}
\description{
This is a master function that goes to all the steps required to obtain
summary statistics from pooled sequencing data.
}
\details{
Starts by creating a vector of parameters, with values drawn from the
respective prior distributions. Then those parameter values are used to
simulate genetic data under a coalescent approach. A series of steps is then
followed to turn that genetic data into pooled sequencing data. Finally, a
set of summary statistics is computed using the simulated pooled sequencing
data.
}
\examples{
# simulate Pool-seq data and compute summary statistics for a model with two populations
poolSim(model="2pops", nDip=400, nPops=2, nLoci=10, nSites=2000, mutrate=1.5e-8,
size=rep(list(rep(5, 20)), 2),mean=c(85, 65), variance=c(1400, 900), minimum=25,
maximum=165, min.minor=2, Nref=c(25000, 25000), ratio=c(0.1, 3), pool=c(5, 250),
seq=c(0.0001, 0.001), split=c(0, 3), CW=c(1e-13, 1e-3), WC=c(1e-13, 1e-3), bT=c(0, 0.5))

# simulate Pool-seq data and compute summary statistics for a model with four populations
poolSim(model="Single", nDip=400, nPops=4, nLoci=10, nSites=2000, mutrate=2e-8,
size=rep(list(rep(5, 20)), 4), mean=c(85, 65, 65, 70), variance=c(1400, 900, 850, 1000),
minimum=25, maximum=165, min.minor=2, Nref=c(25000, 25000), ratio=c(0.1, 3), pool=c(5, 250),
seq=c(0.0001, 0.001), split=c(0, 3), CW=c(1e-13, 1e-3), WC=c(1e-13, 1e-3), CC=c(1e-13, 1e-3),
WW=c(1e-13, 1e-3), ANC=c(1e-13, 1e-3), bT=c(0, 0.2), bCW=c(0, 0.5), bWC=c(0, 0.5))


}
