% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_sumstats.R
\name{popsFST}
\alias{popsFST}
\title{Pairwise FST among populations and across multiple loci}
\usage{
popsFST(nPops, Pop_pi, coverage)
}
\arguments{
\item{nPops}{is an integer indicating how many populations are present in the
data.}

\item{Pop_pi}{is a list of allele frequencies. Each entry of that list is a
matrix representing a different locus. Each row of that matrix should
correspond to a different population and each column to a different site}

\item{coverage}{is a list containing depths of coverage. Each entry of that
list is a matrix representing a different locus. Each row of that matrix
should correspond to a different population and each column to a different
site}
}
\value{
a list where each entry corresponds to a different locus. Each of
those entries is a upper triangular matrix with the pairwise FST values
between each population.
}
\description{
This functions calculates pairwise FST values according to Hudson's estimator
following Bathia. FST values are calculated for each pairwise combination of
the populations present in the data (defined by the \code{nPops} parameter).
}
\details{
This functions performs pairwise comparisons of multiple populations and thus
returns multiple FST values, one for each comparison. Additionally, this
function computes FST for multiple loci, returning a value for each pairwise
comparison per locus.
}
\keyword{internal}
