% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_mc.R
\name{gen_mc}
\alias{gen_mc}
\title{Generate Monte Carlo Estimates}
\usage{
gen_mc(
  fit_all,
  R = 100,
  ...,
  iseed = NULL,
  parallel = FALSE,
  progress = FALSE,
  ncores = max(1, parallel::detectCores(logical = FALSE) - 1),
  compute_implied_stats = FALSE
)
}
\arguments{
\item{fit_all}{The output of
\code{\link[=fit_model]{fit_model()}} or an object of the
class \code{fit_out}.}

\item{R}{The number of replications
to generate the Monte Carlo estimates
for each fit output.}

\item{...}{Optional arguments to be
passed to \code{\link[manymome:do_mc]{manymome::do_mc()}} when
generating the Monte Carlo estimates.}

\item{iseed}{The seed for the random
number generator. Default is \code{NULL}
and the seed is not changed.}

\item{parallel}{If \code{TRUE}, parallel
processing will be used to generate
Monte Carlo estimates for the
fit outputs. Default is \code{FALSE}.}

\item{progress}{If \code{TRUE}, the progress
will be displayed.
Default is `FALSE.}

\item{ncores}{The number of CPU
cores to use if parallel processing
is used.}

\item{compute_implied_stats}{Whether
implied statistics are computed
in each Monte Carlo replication. Usually
not needed and so default to \code{FALSE}.}
}
\value{
An \code{mc_list} object, which is a list
of the output of \code{\link[manymome:do_mc]{manymome::do_mc()}}.
}
\description{
Get a list of the output
of \code{\link[lavaan:sem]{lavaan::sem()}} and generate
Monte Carlo estimates of model
parameters.
}
\details{
The function \code{\link[=gen_mc]{gen_mc()}} simply calls
\code{\link[manymome:do_mc]{manymome::do_mc()}}
on each output of
\code{\link[lavaan:sem]{lavaan::sem()}} in \code{fit_all}. The
simulated
estimates can then be used to test
effects such as indirect effects,
usually by functions from the
\code{manymome} package, such as
\code{\link[manymome:cond_indirect]{manymome::indirect_effect()}}.
}
\section{The role of \code{gen_mc()}}{
This function is used by the
all-in-one function \code{\link[=power4test]{power4test()}}.
Users usually do not call this
function directly, though
developers can use this function to
customize the workflow of the
power analysis.
}

\examples{

# Specify the population model

mod <-
"m ~ x
 y ~ m + x"

# Specify the effect sizes (population parameter values)

es <-
"
y ~ m: m
m ~ x: m
y ~ x: n
"

# Generate several simulated datasets

data_all <- sim_data(nrep = 5,
                     model = mod,
                     pop_es = es,
                     n = 100,
                     iseed = 1234)

# Fit the population model to each datasets

fit_all <- fit_model(data_all)

# Generate Monte Carlo estimates for each replication

mc_all <- gen_mc(fit_all,
                 R = 100,
                 iseed = 4567)

mc_all

}
\seealso{
See \code{\link[=power4test]{power4test()}} for
the all-in-one function that uses
this function.
}
