% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms.varexplore.R
\name{ms.varexplore}
\alias{ms.varexplore}
\title{Variance exploration for a multisite trial with a binary outcome}
\usage{
ms.varexplore(pc, pt, print = TRUE)
}
\arguments{
\item{pc}{The probability of the outcome in control clusters.}

\item{pt}{The probability of the outcome in treatment clusters.}

\item{print}{Whether or not to print the results in a table; defaults to TRUE. To retrieve the results even when print = FALSE, assign the function output to an object.}
}
\value{
A list containing the calculated OR and a dataframe of outputs.
}
\description{
This function can be used to help select a plausible value for the variance/SD of the
random intercept for site in a multisite trial with a binary outcome.
Based on user-supplied values of the outcome proportions in the two conditions,
this function outputs, for a range of possible values of the SD, the intervals
within which we expect about 95\% of the site-specific
odds ratios to lie.
}
\details{
In a multisite trial design, participants are randomized to conditions within site.
The use of this function is illustrated in Crespi CM (2025) Power and Sample Size in R.
}
\examples{
ms.varexplore(pc = 0.1, pt = 0.2)
output <- ms.varexplore(pc = 0.1, pt = 0.2, print = FALSE)
output$OR
}
