% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBioclimVars.R
\name{getBioclimVars}
\alias{getBioclimVars}
\title{getBioclimVars}
\usage{
getBioclimVars(occurrences, which.biovars=c(1:19), 
use.paleoclimate=TRUE, paleoclimateUser=NULL, layerAge=c(0:20))
}
\arguments{
\item{occurrences}{a matrix or data.frame with three columns and rows to represent individuals. The first column must be species name for extant occurrences or the age in closest Ma for fossil occurrences. Second and third column must be Longitude and Latitude.}

\item{which.biovars}{a vector of the numbers of the bioclimatic variables that should be returned. The bioclimatic variables number correspond to the table at (https://www.worldclim.org/data/bioclim.html).}

\item{use.paleoclimate}{if left blank, default North America paleoclimate data is used. If FALSE, user submitted paleoclimate must be provided}

\item{paleoclimateUser}{list of data frames with paleoclimates, must be dataframes with columns: GlobalID, Longitude, Latitude, bio1, bio2,...,bio19.}

\item{layerAge}{vector with the ages of the paleoclimate dataframes, if using user submitted paleoclimate data}
}
\value{
Returns a data frame with the original occurrences input appended with columns of bioclimate variables as specified. If fossils are included, the returned bioclimate variables are from the closest 1 Ma interval of isotopically scaled climate.
}
\description{
This function retrieves the bioclimatic variables described in Nix & Busby (1986) for the specified variables and the specified time period.
}
\details{
The occurrences argument should contain all extant or all fossils. Columns should be in the format: Species, Longitude, Latitude for extant data.

If using the provided paleoclimate data:

Modern time period uses the Hijmans et al. (2005) high resolution climate interpolations.

The time period 10 Ma uses the GCM by Micheels et al (2011) for the Tortonian.

The time period 15 Ma uses the GCM by Krapp & Jungclaus (2011) for the Middle Miocene.

For the one million year intervals outside the modern and past GCMs, the climate was interpolated based on the benthic marine foram stable oxygen isotope ratio curve from Ruddiman et al 1989. The scale of these variables is at a 50 km equidistant point grain size.
}
\examples{
data(occurrences)
biooccur <- getBioclimVars(occurrences,which.biovars=c(3,5))
#returns data frame with bioclimate variables 3 and 5 for occurrence data
}
\references{
Hijmans, R. J. et al. (2005) Very high resolution interpolated climate surfaces for global land areas

Krapp, M. and Jungclaus, J. H. (2011) The Middle Miocene climate as modeled in an atmosphere-ocean-biosphere model. Climate of the Past 7(4):1169-1188

Micheels, A. et al. (2011) Analysis of heat transport mechanisms from a Late Miocene model experiment with a fully-coupled atmosphere-ocean general circulation model. Palaeogeography, Palaeoclimatology, Palaeocology 304: 337-350

Nix, H. and Busby, J. (1986) BIOCLIM, a bioclimatic analysis and prediction system. CSIRO annual report. CSIRO Division of Water and Land Resources, Canberra.

Ruddiman, W. F. et al. (1989) Pleistocene evolution: Northern hemisphere ice sheets and North Atlantic Ocean. Paleoceanography 4: 353-412
}
\author{
A. Michelle Lawing, Alexandra F. C. Howard, Maria-Aleja Hurtado-Materon
}
