% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StudySpecificationAccessors.R
\name{.get_col_from_new_data}
\alias{.get_col_from_new_data}
\title{(Internal) Extract specified \code{type} from new data set}
\usage{
.get_col_from_new_data(
  specification,
  newdata,
  type,
  by = NULL,
  implicitBlock = FALSE,
  ...
)
}
\arguments{
\item{specification}{A \code{StudySpecification}}

\item{newdata}{A \code{data.frame}, which may or may not be the one which
was used to create \code{specification}. It must have the units of
assignment variable(s) (though \code{by=} argument can be used if the name
differ), and will appropriately merge with the \code{specification} the
blocks, treatment or forcings.}

\item{type}{One of "t", "f", or "b".}

\item{by}{optional; named vector or list connecting names of unit of
assignment/unitid/cluster variables in \code{specification} to unit of
assignment/unitid/cluster variables in \code{data}. Names represent
variables in the StudySpecification; values represent variables in the
data. Only needed if variable names differ.}

\item{implicitBlock}{If the \code{StudySpecification} does not include a
block, \code{TRUE} will return a constant 1 for the blocks if \code{type}
requests it.}

\item{...}{Additional arguments to \code{merge()}.}
}
\value{
The column(s) belonging to the requested \code{type} in
}
\description{
(Internal) Extract specified \code{type} from new data set
}
\keyword{internal}
