% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code_modify_func_multi.R
\name{code_modify_func_multi}
\alias{code_modify_func_multi}
\title{Code modify function (multiple variables). To be called by the harmonization function.}
\usage{
code_modify_func_multi(
  data = temp_dataset,
  instruction = code_instruct,
  old_var = source_item_long,
  user_args = source_item,
  sourcedataset = source_dataset,
  subdomain = subdomain,
  visit = visit,
  cohort = cohort
)
}
\arguments{
\item{data}{Dataframe to be modified}

\item{instruction}{Coding instruction from harmonization sheet}

\item{old_var}{Name of original variable}

\item{user_args}{Character vector of input variables}

\item{sourcedataset}{Dataframe created so far}

\item{subdomain}{Category of variable}

\item{visit}{Visit number}

\item{cohort}{Cohort name}
}
\value{
Vector of length equal to \code{old_var}
}
\description{
Code modify function (multiple variables). To be called by the harmonization function.
}
\examples{

# Example calculating BMI in cohort a for visit 1

code_modify_func_multi(data = cohort_a,
                     instruction = '(x1 / 2.205)/((x2 / 39.37)**2)',
                     old_var = 'weight_1; height_1',
                     user_args = c('weight_1','height_1'),
                     sourcedataset = 'cohort_a',
                     subdomain = 'clinical',
                     visit = 1,
                     cohort = 'cohort_a')

}
