% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvars.R
\docType{package}
\name{pvars}
\alias{pvars-package}
\alias{pvars}
\title{pvars: VAR Modeling for Heterogeneous Panels}
\description{
This package implements (1) panel cointegration rank tests, (2) estimators for 
panel vector autoregressive (VAR) models, and (3) identification methods for 
panel structural vector autoregressive (SVAR) models as described in the 
accompanying vignette. 
The implemented functions allow to account for cross-sectional dependence 
and for structural breaks in the deterministic terms of the VAR processes.
}
\details{
\bold{(1)} The panel functions to determine the cointegration rank are:
\itemize{
\item \code{\link{pcoint.JO}}   panel Johansen procedures,
\item \code{\link{pcoint.BR}}   panel test with pooled two-step estimation,
\item \code{\link{pcoint.SL}}   panel Saikkonen-Luetkepohl procedures,
\item \code{\link{pcoint.CAIN}} correlation-augmented inverse normal test.
}

\bold{(2)} The panel functions to estimate the VAR models are:
\itemize{
\item \code{\link{pvarx.VAR}} mean-group of a panel of VAR models,
\item \code{\link{pvarx.VEC}} pooled cointegrating vectors in a panel VECM.
}

\bold{(3)} The panel functions to retrieve structural impact matrices are:
\itemize{
\item \code{\link{pid.chol}} identification of panel SVAR models using Cholesky decomposition to impose recursive causality,
\item \code{\link{pid.grt}}  identification of panel SVEC models by imposing long- and short-run restrictions,
\item \code{\link{pid.iv}}   identification of panel SVAR models by means of proxy variables,
\item \code{\link{pid.dc}}   independence-based identification of panel SVAR models using distance covariance (DC) statistic,
\item \code{\link{pid.cvm}}  independence-based identification of panel SVAR models using Cramer-von Mises (CVM) distance.
}

Supporting tools, such as the specification functions (\code{\link{speci.VAR}}, 
\code{\link{speci.factors}}) and the panel block bootstrap procedure 
(\code{\link{sboot.pmb}}), complement the panel VAR functions and complete 
this coherent approach to \strong{\emph{VAR modeling for heterogeneous panels}} 
within the \strong{vars} ecosystem. The provided data sets further allow for 
the exact replication of the implemented literature.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/Lenni89/pvars}
  \item Report bugs at \url{https://github.com/Lenni89/pvars/issues}
}

}
\author{
Lennart Empting 
\email{lennart.empting@vwl.uni-due.de} 
(ORCID: \href{https://orcid.org/0009-0004-5068-4639}{0009-0004-5068-4639})
}
