% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{make.dumNA}
\alias{make.dumNA}
\title{Make Dummy Columns For Missing Data.}
\usage{
make.dumNA(data, vrb.nm, ov = FALSE, rtn.lgl = FALSE, suffix = "_m")
}
\arguments{
\item{data}{data.frame of data.}

\item{vrb.nm}{character vector of colnames from \code{data} specifying the
variables.}

\item{ov}{logical vector of length 1 specifying whether the dummy columns
should be reverse coded such that missing values = 0/FALSE and observed
values = 1/TRUE.}

\item{rtn.lgl}{logical vector of length 1 specifying whether the dummy columns
should be logical vectors (TRUE) rather than numeric vectors (FALSE).}

\item{suffix}{character vector of length 1 specifying the string that should
be appended to the end of the colnames in the return object.}
}
\value{
data.frame of numeric (logical if \code{rtn.lgl} = TRUE) columns
  where missing = 1 and observed = 0 (flipped if \code{ov} = TRUE) for each
  variable. The colnames are created by \code{paste0(vrb.nm, suffix)}.
}
\description{
\code{make.dumNA} makes dummy columns (i.e., dichomotous numeric vectors
coded 0 and 1) for missing data. Each variable is treated in isolation.
}
\examples{
make.dumNA(data = airquality, vrb.nm = c("Ozone","Solar.R"))
make.dumNA(data = airquality, vrb.nm = c("Ozone","Solar.R"),
   rtn.lgl = TRUE) # logical vectors returned
make.dumNA(data = airquality, vrb.nm = c("Ozone","Solar.R"),
   ov = TRUE, suffix = "_o") # 1 = observed value
}
\seealso{
\code{\link{make.dummy}}
}
