% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_metrics.R
\name{calculate_metrics}
\alias{calculate_metrics}
\title{Generate a dataframe with calculated metrics.}
\usage{
calculate_metrics(
  data,
  meta,
  metrics = c("MPR", "MS", "TtT", "RAF"),
  transpose = FALSE,
  normalize = FALSE,
  start_col = 3L,
  MS_window = 3L,
  threshold = 2
)
}
\arguments{
\item{data}{A dataframe containing the raw RT-QuIC data.}

\item{meta}{A dataframe containing sample metadata. Should include at least the "Sample IDs" column.}

\item{metrics}{An array containing the metrics which should be calculated.}

\item{transpose}{Logical; should the raw data be transposed before performing the calculations?}

\item{normalize}{Logical; should the raw data be normalized before performing the calculations?}

\item{start_col}{Integer; column number denoting where the numeric data begins.}

\item{MS_window}{Integer; width of the window applied in the calculation of max slope.}

\item{threshold}{Float; the threshold applied to the calculation of time-to-threshold.}
}
\value{
A dataframe of calculated metrics.
}
\description{
Uses functions from the "calculate" family of quicR functions to generate an analyzed dataframe.
}
\examples{
file <- system.file(
  "extdata/input_files",
  file = "test4.xlsx",
  package = "quicR"
)

data <- quicR::get_real(file)[[1]] |>
  quicR::normalize_RFU()

meta <- quicR::organize_tables(file) |>
  quicR::convert_tables()

calculate_metrics(data, meta)

}
