% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_y.R
\name{reg_y}
\alias{reg_y}
\title{Build regression models with more than one dependent variable}
\usage{
reg_y(data = NULL, x = NULL, y = NULL, cov = NULL, factors = NULL,
  model = NULL, time = NULL, confint_glm = "default", cov_show = FALSE)
}
\arguments{
\item{data}{A data.frame}

\item{x}{Integer column indices or names of the variables to be included in univariate analysis, the default columns are all the variables except `y` and `time` and `cov`.}

\item{y}{Integer column indices or name of dependent variable}

\item{cov}{Integer column indices or name of covariate variables}

\item{factors}{Integer column indices or names of variables to be treated as factor}

\item{model}{regression model, see \code{\link{lm}}, \code{\link{glm}}, \code{\link[survival]{coxph}} for more details}

\item{time}{Integer column indices  or name of survival time, used in cox regression, see \code{\link[survival]{coxph}} for more details}

\item{confint_glm}{A character, 'default' or 'profile'. The default method for 'glm' class to compute confidence intervals assumes asymptotic normality \code{\link[stats]{confint}}, you can also use profile likelihood method \code{\link[MASS]{confint.glm}}, but it is pretty slow.
In this case you could specify 'default' for speed.}

\item{cov_show}{A logical, whether to create covariates result, default FALSE}
}
\value{
The return result is a concentrated result in a  data.frame.
}
\description{
Build general linear model, generalized linear model, cox regression model,etc.
}
