% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sourceSHAPE.R
\name{birthFunction}
\alias{birthFunction}
\title{This function calculates the number of births for the vector of populations which are expected to be passed.
The number of parameters which can be passed may be more than the number required to use one of the growth forms.}
\usage{
birthFunction(func_inSize, func_inFitness, func_bProb, func_sizeStep,
  func_growthForm = c("logistic", "exponential", "constant", "poisson"),
  func_deaths = NULL, func_carryingCapacity = NULL,
  func_basalRate = NULL, func_deathScale = FALSE, func_drift = TRUE,
  func_roundValues = TRUE)
}
\arguments{
\item{func_inSize}{This is the vector of population sizes within the community}

\item{func_inFitness}{This is the vector of fitness value for the community}

\item{func_bProb}{This is the general bith probability defined for this run of SHAPE}

\item{func_sizeStep}{This is a proportional scalar that will control what proportion of a standard
"generation" is simulated for each step within a SHAPE run.  NOTE: This parameter is not perfectly
validated to run as may be expected with all models.  For now, it should be left as a value of "1",
but exists for future implementation and testing.}

\item{func_growthForm}{This is the implemeted growth model to be simulated in this run.  Currently
this can be one of \strong{"logistic","exponential","constant","poisson"}.}

\item{func_deaths}{This is the vector of deaths for the genotypes within the community}

\item{func_carryingCapacity}{This is the maximum community size supported by tge simulated environment.}

\item{func_basalRate}{This is the basal growth rate, otherwise definable as the number of offspring
an individual will produce from a single birth event.}

\item{func_deathScale}{This is a logical toggle to define if the number of births should be scaled
by the number of deaths.  The exact interpretation of this varies by growth model, but in general
it forces growth to follow rates expected by standard pure birth models while still simulating
deaths within the community.}

\item{func_drift}{This is a logical toggle as to whether or not stochasticity is introduced into
the deterministic calculations that may be encountered within the growth function.  Its exact
implementation varies based on the growth model being simulated.}

\item{func_roundValues}{This is a logical toggle to define if the number of births and deaths are
forced to be tracked as integer values.  If TRUE, then any fractional amounts will be stochastically
rounded to the nearest integer with a probability of being rounded up equal to the decimal value
-- ie: 0.32 means 32\% chance of being rounded up --}
}
\value{
A vector of births with the same length as the vector of population sizes passed.

# Imagine you've got an evolving community of three populations where in each time step individuals with
# relateive fitness of 1 produce 2 offspring.
birthFunction(func_inSize = c(100,100,100), func_inFitness = c(1,2,1.05), func_bProb = 1,
func_sizeStep = 1, func_growthForm = "exponential", func_drift = FALSE)
# Now with evolutionary drift
birthFunction(func_inSize = c(100,100,100), func_inFitness = c(1,2,1.05), func_bProb = 1,
func_sizeStep = 1, func_growthForm = "exponential", func_drift = TRUE)
}
\description{
This function calculates the number of births for the vector of populations which are expected to be passed.
The number of parameters which can be passed may be more than the number required to use one of the growth forms.
}
