% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sourceSHAPE.R
\name{expGrowth}
\alias{expGrowth}
\title{This function uses the exponential growth model and can either calculated the expected growth for a single time step
OR it can work backwards to calculated what was the expected starting population size prior to a step of exponential growth.}
\usage{
expGrowth(func_rate, func_step, func_startPop = NULL,
  func_endPop = NULL)
}
\arguments{
\item{func_rate}{This is the number of offpsring expected to be produced by an individual.  When calculating the expected
population size after a time step, we force this rate to be no less than 1 since this function has meaning only in the birth
function and so we do not want to calculate negative births (which would mean deaths).}

\item{func_step}{This is a proportional scalar that will control what proportion of a standard
"generation" is simulated for each step within a SHAPE run.  NOTE: This parameter is not perfectly
validated to run as may be expected with all models.  For now, it should be left as a value of "1",
but exists for future implementation and testing.}

\item{func_startPop}{This is the initial population size(s) for which you want to calculate a final size.  Leave NULL
if trying to calculated the expected initial size from a final population.}

\item{func_endPop}{This is the final population size(s) for which you want to calculate a initial size.  Leave NULL
if trying to calculated the expected final size from an initial population.}
}
\value{
numeric value
}
\description{
This function uses the exponential growth model and can either calculated the expected growth for a single time step
OR it can work backwards to calculated what was the expected starting population size prior to a step of exponential growth.
}
\examples{
# Exponential growth equation implemented but allowing either the final or initial population
# to be calculated based on whethere the initial or final community size is input.
expGrowth(func_rate = 2, func_step = 1,func_startPop = 100)
expGrowth(func_rate = 2, func_step = 1,func_endPop = 200)
expGrowth(func_rate = 2, func_step = 7,func_startPop = 100)
# You cannot set a growth rate less than 1 as this would then simulate deaths which is not
# allowed in this calculation.
expGrowth(func_rate = c(0.9,1,1.1), func_step = 1,func_startPop = 100)
}
