% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphNEL.R
\name{spectral_graphNEL}
\alias{spectral_graphNEL}
\title{Spectral clustering for \code{\link[graph]{graphNEL}} objects}
\usage{
spectral_graphNEL(g, Cn_min = 1L, tol = 1e-05, names = 1L, fix_neig = 0L)
}
\arguments{
\item{g}{\code{\link[graph]{graphNEL}} object}

\item{Cn_min}{minimum cluster size}

\item{tol}{tolerance}

\item{names}{are we dealing with alphaNumeric (1) or numeric (!1) ids}

\item{fix_neig}{whether to fix neighbouring nodes found in same community}
}
\value{
\code{data.frame} with node names and membership information
}
\description{
Spectral clustering for \code{\link[graph]{graphNEL}} objects
}
\examples{
library(graph)
V = letters[1:12]
g2 = randomEGraph(V, edges=20)
mem.df = spectral_graphNEL(g2)
head(mem.df)
}
\seealso{
\code{\link{spectral_igraph_membership}}
}
