% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agg_dev.R
\name{agg_tiff}
\alias{agg_tiff}
\title{Draw to a TIFF file}
\usage{
agg_tiff(
  filename = "Rplot\%03d.tiff",
  width = 480,
  height = 480,
  units = "px",
  pointsize = 12,
  background = "white",
  res = 72,
  compression = "none",
  bitsize = 8
)
}
\arguments{
\item{filename}{The name of the file. Follows the same semantics as the file 
naming in [grDevices::png()], meaning that you can provide a [sprintf()] 
compliant string format to name multiple plots (such as the default value)}

\item{width}{The dimensions of the device}

\item{height}{The dimensions of the device}

\item{units}{The unit `width` and `height` is measured in, in either pixels 
(`'px'`), inches (`'in'`), millimeters (`'mm'`), or centimeter (`'cm'`).}

\item{pointsize}{The default pointsize of the device in pt}

\item{background}{The background colour of the device}

\item{res}{The resolution of the device. This setting will govern how device
dimensions given in inches, centimeters, or millimeters will be converted
to pixels. Further, it will be used to scale text sizes and linewidths}

\item{compression}{The compression type to use for the image data. The 
standard options from the [grDevices::tiff()] function are available under 
the same name.}

\item{bitsize}{Should the device record colour as 8 or 16bit}
}
\description{
The TIFF (Tagged Image File Format) format is a very versatile raster image
storage format that supports 8 and 16bit colour mode, true transparency, as
well as a range of other features not relevant to drawing from R (e.g. 
support for different colour spaces). The storage mode of the image data is
not fixed and different compression modes are possible, in contrast to PNGs
one-approach-fits-all. The default (uncompressed) will result in much larger
files than PNG, and in general PNG is a better format for many of the graphic
types produced in R. Still, TIFF has its purposes and sometimes this file
format is explicetly requested.
}
\note{
`'jpeg'` compression is only available if ragg is compiled with a 
version of `libtiff` where jpeg support has been turned on.
}
\section{Transparency}{

TIFF have support for true transparency, meaning that the pixel colour is 
stored in pre-multiplied form. This is in contrast to pixels being stored in 
plain format, where the alpha values more function as a mask. The utility of
this is not always that important, but it is one of the benefits of TIFF over
PNG so it should be noted.
}

\examples{
file <- tempfile(fileext = '.tiff')
# Use jpeg compression
agg_tiff(file, compression = 'lzw+p')
plot(sin, -pi, 2*pi)
dev.off()

}
