% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{rainette_plot}
\alias{rainette_plot}
\title{Generate a clustering description plot from a rainette result}
\usage{
rainette_plot(
  res,
  dtm,
  k = NULL,
  type = c("bar", "cloud"),
  n_terms = 15,
  free_scales = FALSE,
  measure = c("chi2", "lr", "frequency", "docprop"),
  show_negative = FALSE,
  text_size = NULL
)
}
\arguments{
\item{res}{result object of a \code{rainette} clustering}

\item{dtm}{the dfm object used to compute the clustering}

\item{k}{number of groups. If NULL, use the biggest number possible}

\item{type}{type of term plots : barplot or wordcloud}

\item{n_terms}{number of terms to display in keyness plots}

\item{free_scales}{if TRUE, all the keyness plots will have the same scale}

\item{measure}{statistics to compute}

\item{show_negative}{if TRUE, show negative keyness features}

\item{text_size}{font size for barplots, max word size for wordclouds}
}
\value{
A gtable object.
}
\description{
Generate a clustering description plot from a rainette result
}
\examples{
\donttest{
require(quanteda)
corpus <- data_corpus_inaugural
corpus <- head(corpus, n = 10)
corpus <- split_segments(corpus)
tok <- tokens(corpus, remove_punct = TRUE)
tok <- tokens_remove(tok, stopwords("en"))
dtm <- dfm(tok, tolower = TRUE)
dtm <- dfm_trim(dtm, min_docfreq = 3)
res <- rainette(dtm, k = 3, min_segment_size = 15)
rainette_plot(res, dtm)
}

}
\seealso{
\code{\link[quanteda.textstats:textstat_keyness]{quanteda.textstats::textstat_keyness()}}, \code{\link[=rainette_explor]{rainette_explor()}}, \code{\link[=rainette_stats]{rainette_stats()}}
}
