% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kbl-defaults.R
\name{fmt_kbl_header}
\alias{fmt_kbl_header}
\title{Wrapper function of kableExtra::row_spec}
\usage{
fmt_kbl_header(
  kable_input,
  row = 0,
  align = "c",
  extra_css = "border-bottom: 0.16em solid #111111",
  ...
)
}
\arguments{
\item{kable_input}{Output of \code{knitr::kable()} with \code{format} specified}

\item{row}{A numeric value or vector indicating which row(s) to be selected. You don't
need to count in header rows or group labeling rows.}

\item{align}{A character string for cell alignment. For HTML, possible values could
be \code{l}, \code{c}, \code{r} plus \code{left}, \code{center}, \code{right}, \code{justify}, \code{initial} and \code{inherit}
while for LaTeX, you can only choose from \code{l}, \code{c} & \code{r}.}

\item{extra_css}{Extra css text to be passed into the cells of the row. Note
that it's not for the whole row.}

\item{...}{Additional arguments passed to \code{\link[kableExtra:row_spec]{kableExtra::row_spec()}}}
}
\value{
A kable object.
}
\description{
Apply some default formatting to the header row of a kable table. Should be
called after any calls to \code{\link[kableExtra:column_spec]{kableExtra::column_spec()}}.
}
\examples{
fmt_kbl(mtcars[, 1:3], align = c("r", "c", "r"),
    col.names = c("Column 1", "Column 2", "Column 3"),
    caption = "Example Table Title") \%>\%
  kableExtra::column_spec(1, width = "20em") \%>\%
  fmt_kbl_header()
}
