% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strategies.R
\name{strategies}
\alias{strategies}
\alias{strategy_MAR}
\alias{strategy_JR}
\alias{strategy_CR}
\alias{strategy_CIR}
\alias{strategy_LMCF}
\title{Strategies}
\usage{
strategy_MAR(pars_group, pars_ref, index_mar)

strategy_JR(pars_group, pars_ref, index_mar)

strategy_CR(pars_group, pars_ref, index_mar)

strategy_CIR(pars_group, pars_ref, index_mar)

strategy_LMCF(pars_group, pars_ref, index_mar)
}
\arguments{
\item{pars_group}{A list of parameters for the subject's group. See details.}

\item{pars_ref}{A list of parameters for the subject's reference group. See details.}

\item{index_mar}{A logical vector indicating which visits meet the MAR assumption
for the subject. I.e. this identifies the observations after a non-MAR
intercurrent event (ICE).}
}
\description{
These functions are used to implement various reference based imputation
strategies by combining a subjects own distribution with that of
a reference distribution based upon which of their visits failed to meet
the Missing-at-Random (MAR) assumption.
}
\details{
\code{pars_group} and \code{pars_ref} both must be a list containing elements \code{mu} and \code{sigma}.
\code{mu} must be a numeric vector and \code{sigma} must be a square matrix symmetric covariance
matrix with dimensions equal to the length of \code{mu} and \code{index_mar}. e.g.

\if{html}{\out{<div class="sourceCode">}}\preformatted{list(
    mu = c(1,2,3),
    sigma = matrix(c(4,3,2,3,5,4,2,4,6), nrow = 3, ncol = 3)
)
}\if{html}{\out{</div>}}

Users can define their own strategy functions and include them via the \code{strategies}
argument to \code{\link[=impute]{impute()}} using \code{\link[=getStrategies]{getStrategies()}}. That being said the following
strategies are available "out the box":
\itemize{
\item Missing at Random (MAR)
\item Jump to Reference (JR)
\item Copy Reference (CR)
\item Copy Increments in Reference (CIR)
\item Last Mean Carried Forward (LMCF)
}
}
