% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{get_data_dictionary}
\alias{get_data_dictionary}
\title{Extract data dictionary from RCDF object}
\usage{
get_data_dictionary(data)
}
\arguments{
\item{data}{Object of class \code{rcdf}.}
}
\value{
A data frame that serves as a metadata dictionary. It must contain
  at least the columns: \code{variable_name}, \code{label}, and \code{type}. Optionally,
  it may include a \code{valueset} column for categorical variables, which should be
  a list column with data frames containing \code{value} and \code{label} columns.
}
\description{
This function retrieves the data dictionary embedded in the RCDF object
}
\examples{
dir <- system.file("extdata", package = "rcdf")
rcdf_path <- file.path(dir, 'mtcars.rcdf')
private_key <- file.path(dir, 'sample-private-key.pem')

rcdf_data <- read_rcdf(path = rcdf_path, decryption_key = private_key)
data_dictionary <- get_data_dictionary(rcdf_data)
names(data_dictionary)
}
