% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family-timselstat.R, R/op-cdo-timselavg.R,
%   R/op-cdo-timselmax.R, R/op-cdo-timselmean.R, R/op-cdo-timselmin.R,
%   R/op-cdo-timselrange.R, R/op-cdo-timselstd.R, R/op-cdo-timselstd1.R,
%   R/op-cdo-timselsum.R, R/op-cdo-timselvar.R, R/op-cdo-timselvar1.R
\name{timselstat}
\alias{timselstat}
\alias{cdo_timselavg}
\alias{cdo_timselmax}
\alias{cdo_timselmean}
\alias{cdo_timselmin}
\alias{cdo_timselrange}
\alias{cdo_timselstd}
\alias{cdo_timselstd1}
\alias{cdo_timselsum}
\alias{cdo_timselvar}
\alias{cdo_timselvar1}
\title{Time range statistics}
\usage{
cdo_timselavg(ifile, nsets = NULL, noffset = NULL, nskip = NULL, ofile = NULL)

cdo_timselmax(ifile, nsets = NULL, noffset = NULL, nskip = NULL, ofile = NULL)

cdo_timselmean(ifile, nsets = NULL, noffset = NULL, nskip = NULL, ofile = NULL)

cdo_timselmin(ifile, nsets = NULL, noffset = NULL, nskip = NULL, ofile = NULL)

cdo_timselrange(
  ifile,
  nsets = NULL,
  noffset = NULL,
  nskip = NULL,
  ofile = NULL
)

cdo_timselstd(ifile, nsets = NULL, noffset = NULL, nskip = NULL, ofile = NULL)

cdo_timselstd1(ifile, nsets = NULL, noffset = NULL, nskip = NULL, ofile = NULL)

cdo_timselsum(ifile, nsets = NULL, noffset = NULL, nskip = NULL, ofile = NULL)

cdo_timselvar(ifile, nsets = NULL, noffset = NULL, nskip = NULL, ofile = NULL)

cdo_timselvar1(ifile, nsets = NULL, noffset = NULL, nskip = NULL, ofile = NULL)
}
\arguments{
\item{ifile}{String with the path to the input file.}

\item{nsets}{INTEGER - Number of input timesteps for each output timestep}

\item{noffset}{INTEGER - Number of input timesteps skipped before the first timestep range (optional)}

\item{nskip}{INTEGER - Number of input timesteps skipped between timestep ranges (optional)}

\item{ofile}{String with the path to the output file.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operatos that don't return filenames return a character vector with the
string output.
}
\description{
This module computes statistical values for a selected number of timesteps. According to the chosen operator the minimum, maximum, range, sum, average, variance or standard deviation of the selected timesteps is written to outfile. The time of outfile is determined by the time in the middle of all contributing timesteps of infile. This can be change with the CDO option --timestat_date <first|middle|last>.
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{timselmin    Time selection minimum
             For every adjacent sequence t1, ...., tn of timesteps of the same selected time range it is:
             
             o(t,x) = min\\\{i(t',x), t1 &lt; t' &lt;= tn\\\}
timselmax    Time selection maximum
             For every adjacent sequence t1, ...., tn of timesteps of the same selected time range it is:
             
             o(t,x) = max\\\{i(t',x), t1 &lt; t' &lt;= tn\\\}
timselrange  Time selection range
             For every adjacent sequence t1, ...., tn of timesteps of the same selected time range it is:
             
             o(t,x) = range\\\{i(t',x), t1 &lt; t' &lt;= tn\\\}
timselsum    Time selection sum
             For every adjacent sequence t1, ...., tn of timesteps of the same selected time range it is:
             
             o(t,x) = sum\\\{i(t',x), t1 &lt; t' &lt;= tn\\\}
timselmean   Time selection mean
             For every adjacent sequence t1, ...., tn of timesteps of the same selected time range it is:
             
             o(t,x) = mean\\\{i(t',x), t1 &lt; t' &lt;= tn\\\}
timselavg    Time selection average
             For every adjacent sequence t1, ...., tn of timesteps of the same selected time range it is:
             
             o(t,x) = avg\\\{i(t',x), t1 &lt; t' &lt;= tn\\\}
timselstd    Time selection standard deviation
             Normalize by n. For every adjacent sequence t1, ...., tn of timesteps of the same selected time range it is:
             
             o(t,x) = std\\\{i(t',x), t1 &lt; t' &lt;= tn\\\}
timselstd1   Time selection standard deviation (n-1)
             Normalize by (n-1). For every adjacent sequence t1, ...., tn of timesteps of the same selected time range it is:
             
             o(t,x) = std1\\\{i(t',x), t1 &lt; t' &lt;= tn\\\}
timselvar    Time selection variance
             Normalize by n. For every adjacent sequence t1, ...., tn of timesteps of the same selected time range it is:
             
             o(t,x) = var\\\{i(t',x), t1 &lt; t' &lt;= tn\\\}
timselvar1   Time selection variance (n-1)
             Normalize by (n-1). For every adjacent sequence t1, ...., tn of timesteps of the same selected time range it is:
             
             o(t,x) = var1\\\{i(t',x), t1 &lt; t' &lt;= tn\\\}
}\if{html}{\out{</div>}}
}
