% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_functions.R
\name{db_query}
\alias{db_query}
\title{Query an RSQLite database.}
\usage{
db_query(
  codelist,
  db_open = NULL,
  db = NULL,
  db_filepath = NULL,
  db_cprd = c("aurum", "gold"),
  tab = c("observation", "drugissue", "clinical", "immunisation", "test", "therapy",
    "hes_primary", "death"),
  codelist_vector = NULL
)
}
\arguments{
\item{codelist}{Name of codelist to query the database with.}

\item{db_open}{An open SQLite database connection created using RSQLite::dbConnect, to be queried.}

\item{db}{Name of SQLITE database on hard disk, to be queried.}

\item{db_filepath}{Full filepath to SQLITE database on hard disk, to be queried.}

\item{db_cprd}{CPRD Aurum ('aurum') or gold ('gold').}

\item{tab}{Name of table in SQLite database that is to be queried.}

\item{codelist_vector}{Vector of codes to query the database with. This takes precedent over \code{codelist} if both are specified.}
}
\value{
A data.table with observations contained in the specified codelist.
}
\description{
Query an RSQLite database stored on the hard disk for observations with specific codes.
}
\details{
Specifying \code{db} requires a specific underlying directory structure. The SQLite database must be stored in "data/sql/" relative to the working directory.
If the SQLite database is accessed through \code{db}, the connection will be opened and then closed after the query is complete. The same is true if
the database is accessed through \code{db_filepath}. A connection to the SQLite database can also be opened manually using \code{RSQLite::dbConnect}, and then
using the object as input to parameter \code{db_open}. After wards, the connection must be closed manually using \code{RSQLite::dbDisconnect}. If \code{db_open} is specified, this will take precedence over \code{db} or \code{db_filepath}.

Specifying \code{codelist} requires a specific underlying directory structure. The codelist on the hard disk must be stored in "codelists/analysis/" relative
to the working directory, must be a .csv file, and contain a column "medcodeid", "prodcodeid" or "ICD10" depending on the chosen \code{tab}. The codelist can
also be read in manually, and supplied as a character vector to \code{codelist_vector}. If \code{codelist_vector} is defined, this will take precedence over \code{codelist}.
}
\examples{
## Create connection to a temporary database
aurum_extract <- connect_database(file.path(tempdir(), "temp.sqlite"))

## Add observation data from all observation files in specified directory
cprd_extract(db = aurum_extract,
filepath = system.file("aurum_data", package = "rcprd"),
filetype = "observation")

## Query database for a specific medcode
db_query(db_open = aurum_extract,
tab ="observation",
codelist_vector = "187341000000114")

## clean up
RSQLite::dbDisconnect(aurum_extract)
unlink(file.path(tempdir(), "temp.sqlite"))

}
