% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_envir.R
\name{set_envir}
\alias{set_envir}
\title{Set projection and computation region from a raster file.}
\usage{
set_envir(file, ...)
}
\arguments{
\item{file}{The file path to a raster that should be used to set environment parameters such as the projection, cell size, extent, etc. The \code{file} argument will automatically be imported into the mapset as \code{basename(file)}.}

\item{...}{Optional arguments for \code{raster_to_mapset()}. The main argument of interest for most users will be \code{overwrite}, which should be set to true if an object of name \code{basename(file)} already exists in the mapset.}
}
\value{
Nothing. Displays current environment settings.
}
\description{
This function simplifies the process of setting up a GRASS environment with parameters such as cell snapping, size and mapset extent.
}
\examples{
# Will only run if GRASS is running
# You should load rdwplus and initialise GRASS with initGRASS
if(check_running()){

# Load data set
dem <- system.file("extdata", "dem.tif", package = "rdwplus")

# Set environment 
set_envir(dem)

}
}
