% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fopen_file.R
\name{f_open_file}
\alias{f_open_file}
\title{Open a File with the Default Application}
\usage{
f_open_file(filepath)
}
\arguments{
\item{filepath}{A character string specifying the path to the file to be opened. The path can be absolute or relative.}
}
\value{
Does not return a value; it is called for its side effect of opening a file.
}
\description{
Opens a specified file using the default application associated with its file type. It automatically detects the operating system (Windows, Linux, or macOS) and uses the appropriate command to open the file.
}
\details{
- On \bold{Windows}, the \code{f_open_file()} function uses \code{shell.exec()} to open the file.
- On \bold{Linux}, it uses \code{xdg-open} via the \code{system()} function.
- On \bold{macOS}, it uses \code{open} via the \code{system()} function.

If an unsupported operating system is detected, the function will throw a message.
}
\examples{
# NOTE: The use of "if(interactive())" prevents this example from running
# during automated CRAN checks. This is necessary because the example
# opens a file, a behavior restricted by CRAN policies for automated
# testing.You don't need to use "if(interactive())" in your own scripts.
if(interactive()) {
# Open a PDF file.
f_open_file("example.pdf")

# Open an image file.
f_open_file("image.png")

# Open a text file.
f_open_file("document.txt")
}

}
\seealso{
[shell.exec()], [system()]
}
\author{
Sander H. van Delden  \email{plantmind@proton.me} \cr
}
