% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructPedigree.R
\name{constructPedigree}
\alias{constructPedigree}
\title{Pedigree construction}
\usage{
constructPedigree(kappa, describe = TRUE, verbose = FALSE)
}
\arguments{
\item{kappa}{A probability vector of length 3; \eqn{(kappa0, kappa1,
kappa2)}{(\kappa_0, \kappa_1, \kappa_2)}.}

\item{describe}{A logical. If TRUE, a textual description of the resulting
relationship is printed.}

\item{verbose}{A logical. If TRUE, various details about the calculations are
printed.}
}
\value{
A \code{ped} object containing a pair of double half cousins with inbred
founders. (In corner cases the relationship collapses into siblings.)
}
\description{
Construct a pedigree yielding a prescribed set of IBD coefficients.
}
\details{
The construction follows the method and formulae given in Vigeland (2020).
}
\examples{

# Full siblings
x = constructPedigree(kappa = c(0.25, 0.5, 0.25))
kappaIBD(x, leaves(x))

# A relationship halfway between parent-child and full sibs
kap = c(1/8, 6/8, 1/8)
showInTriangle(kap, label = " (1/8, 1/8)", pos = 4)

y = constructPedigree(kappa = kap)
plot(y)

stopifnot(all.equal(kappaIBD(y, leaves(y)), kap))

# kappa = (0,1,0) does not give a parent-child relationship,
# but half siblings whose shared parent is completely inbred.
z = constructPedigree(kappa = c(0,1,0))
plot(z)

}
\references{
M. D. Vigeland (2020). \emph{Relatedness coefficients in pedigrees
with inbred founders}. Journal of mathematical biology.
\doi{https://doi.org/10.1007/s00285-020-01505-x}
}
